/*
 * Decompiled with CFR 0.152.
 */
package com.strategicgains.syntaxe;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ValidationException
extends RuntimeException {
    private static final long serialVersionUID = 2687232338572123535L;
    private List<String> errors = new ArrayList<String>();

    public ValidationException() {
    }

    public ValidationException(String message) {
        super(message);
    }

    public ValidationException(Throwable cause) {
        super(cause);
    }

    public ValidationException(String message, Throwable cause) {
        super(message, cause);
    }

    public ValidationException(List<String> errors) {
        this(ValidationException.joinErrors(errors));
        this.errors = errors;
    }

    public ValidationException(List<String> errors, Throwable cause) {
        this(ValidationException.joinErrors(errors), cause);
        this.errors = errors;
    }

    public List<String> getErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    protected static String joinErrors(List<String> errors) {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (String error : errors) {
            if (!isFirst) {
                sb.append(", ");
            }
            sb.append(error);
            isFirst = false;
        }
        return sb.toString();
    }
}

