/*
 * Decompiled with CFR 0.152.
 */
package org.restexpress.url;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.restexpress.url.UrlMatch;
import org.restexpress.url.UrlMatcher;

public class UrlRegex
implements UrlMatcher {
    public static final String PARAMETER_PREFIX = "regexGroup";
    private Pattern pattern;

    public UrlRegex(String regex) {
        this(Pattern.compile(regex));
    }

    public UrlRegex(Pattern pattern) {
        this.setPattern(pattern);
    }

    @Override
    public String getPattern() {
        return this.pattern.pattern();
    }

    private void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    @Override
    public List<String> getParameterNames() {
        return null;
    }

    @Override
    public boolean matches(String url) {
        return this.match(url) != null;
    }

    @Override
    public UrlMatch match(String url) {
        Matcher matcher = this.pattern.matcher(url);
        if (matcher.matches()) {
            return new UrlMatch(this.extractParameters(matcher));
        }
        return null;
    }

    private Map<String, String> extractParameters(Matcher matcher) {
        HashMap<String, String> values = new HashMap<String, String>();
        for (int i = 0; i < matcher.groupCount(); ++i) {
            String value = matcher.group(i + 1);
            if (value == null) continue;
            values.put(PARAMETER_PREFIX + i, value);
        }
        return values;
    }
}

