/*
 * Decompiled with CFR 0.152.
 */
package org.restexpress.serialization;

import java.nio.ByteBuffer;
import org.restexpress.Request;
import org.restexpress.Response;
import org.restexpress.response.ResponseProcessor;

public class SerializationSettings {
    private String mediaType;
    private ResponseProcessor processor;

    public SerializationSettings(String mediaType, ResponseProcessor processor) {
        this.mediaType = mediaType;
        this.processor = processor;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public ResponseProcessor getResponseProcessor() {
        return this.processor;
    }

    public <T> T deserialize(Request request, Class<T> type) {
        return this.processor.deserialize(request, type);
    }

    public ByteBuffer serialize(Response response) {
        if (!response.hasHeader("Content-Type")) {
            response.setContentType(this.mediaType);
        }
        return this.processor.serialize(response);
    }
}

