/*
 * Decompiled with CFR 0.152.
 */
package org.restexpress.route.parameterized;

import io.netty.handler.codec.http.HttpMethod;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.restexpress.domain.metadata.RouteMetadata;
import org.restexpress.route.Route;
import org.restexpress.route.RouteBuilder;
import org.restexpress.route.parameterized.ParameterizedRoute;
import org.restexpress.settings.RouteDefaults;

public class ParameterizedRouteBuilder
extends RouteBuilder {
    private List<String> aliases = new ArrayList<String>();

    public ParameterizedRouteBuilder(String uri, Object controller, RouteDefaults defaults) {
        super(uri, controller, defaults);
    }

    @Override
    protected Route newRoute(String pattern, Object controller, Method action, HttpMethod method, boolean shouldSerializeResponse, String name, List<String> supportedFormats, String defaultFormat, Set<String> flags, Map<String, Object> parameters, String baseUrl) {
        ParameterizedRoute r = new ParameterizedRoute(pattern, controller, action, method, shouldSerializeResponse, name, supportedFormats, defaultFormat, flags, parameters, baseUrl);
        r.addAliases(this.aliases);
        return r;
    }

    public ParameterizedRouteBuilder alias(String uri) {
        if (!this.aliases.contains(uri)) {
            this.aliases.add(uri);
        }
        return this;
    }

    @Override
    public RouteMetadata asMetadata() {
        RouteMetadata metadata = super.asMetadata();
        for (String alias : this.aliases) {
            metadata.addAlias(alias);
        }
        return metadata;
    }

    @Override
    protected String toRegexPattern(String uri) {
        String pattern = uri;
        if (pattern != null && !pattern.startsWith("/")) {
            pattern = "/" + pattern;
        }
        return pattern;
    }
}

