/*
 * Decompiled with CFR 0.152.
 */
package org.restexpress.route;

import io.netty.handler.codec.http.HttpMethod;
import java.util.List;
import org.restexpress.Request;
import org.restexpress.exception.MethodNotAllowedException;
import org.restexpress.exception.NotFoundException;
import org.restexpress.route.Action;
import org.restexpress.route.Route;
import org.restexpress.route.RouteMapping;
import org.restexpress.util.Resolver;

public class RouteResolver
implements Resolver<Action> {
    private RouteMapping routeMapping;

    public RouteResolver(RouteMapping routes) {
        this.routeMapping = routes;
    }

    public Route getNamedRoute(String name, HttpMethod method) {
        return this.routeMapping.getNamedRoute(name, method);
    }

    @Override
    public Action resolve(Request request) {
        Action action = this.routeMapping.getActionFor(request.getEffectiveHttpMethod(), request.getPath());
        if (action != null) {
            return action;
        }
        List<HttpMethod> allowedMethods = this.routeMapping.getAllowedMethods(request.getPath());
        if (allowedMethods != null && !allowedMethods.isEmpty()) {
            throw new MethodNotAllowedException(request.getUrl(), allowedMethods);
        }
        throw new NotFoundException("Unresolvable URL: " + request.getUrl());
    }
}

