/*
 * Decompiled with CFR 0.152.
 */
package org.restexpress.exception;

import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.Collections;
import java.util.List;
import org.restexpress.Response;
import org.restexpress.common.util.StringUtils;
import org.restexpress.exception.ServiceException;

public class MethodNotAllowedException
extends ServiceException {
    private static final long serialVersionUID = 4116758162425337982L;
    private static final HttpResponseStatus STATUS = HttpResponseStatus.METHOD_NOT_ALLOWED;
    private List<HttpMethod> allowedMethods;

    public MethodNotAllowedException(List<HttpMethod> allowed) {
        super(STATUS);
        this.setAllowedMethods(allowed);
    }

    public MethodNotAllowedException(String message, List<HttpMethod> allowed) {
        super(STATUS, message);
        this.setAllowedMethods(allowed);
    }

    public MethodNotAllowedException(Throwable cause, List<HttpMethod> allowed) {
        super(STATUS, cause);
        this.setAllowedMethods(allowed);
    }

    public MethodNotAllowedException(String message, Throwable cause, List<HttpMethod> allowed) {
        super(STATUS, message, cause);
        this.setAllowedMethods(allowed);
    }

    public void setAllowedMethods(List<HttpMethod> allowed) {
        this.allowedMethods = Collections.unmodifiableList(allowed);
    }

    public List<HttpMethod> getAllowedMethods() {
        return this.allowedMethods;
    }

    @Override
    public void augmentResponse(Response response) {
        response.addHeader("Allow", StringUtils.join((String)",", this.getAllowedMethods()));
    }
}

