/*
 * Decompiled with CFR 0.152.
 */
package org.restexpress.exception;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.restexpress.exception.ExceptionMapping;
import org.restexpress.exception.ServiceException;

public class LegacyExceptionMapper
implements ExceptionMapping {
    private Map<Class<? extends Throwable>, Class<? extends ServiceException>> exceptions = new HashMap<Class<? extends Throwable>, Class<? extends ServiceException>>();

    @Override
    public <T extends Throwable, U extends ServiceException> void map(Class<T> inExceptionClass, Class<U> outExceptionClass) {
        this.exceptions.put(inExceptionClass, outExceptionClass);
    }

    @Override
    public ServiceException getExceptionFor(Throwable throwable) {
        Class<? extends ServiceException> mapped = this.exceptions.get(throwable.getClass());
        if (mapped != null) {
            try {
                Constructor<? extends ServiceException> constructor = mapped.getConstructor(String.class, Throwable.class);
                return constructor.newInstance(throwable.getMessage(), throwable);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

