/*
 * Decompiled with CFR 0.152.
 */
package org.restexpress.exception;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.restexpress.exception.ExceptionMapping;
import org.restexpress.exception.ServiceException;

public class DefaultExceptionMapper
implements ExceptionMapping {
    private Map<Class<? extends Throwable>, Class<? extends ServiceException>> exceptions = new HashMap<Class<? extends Throwable>, Class<? extends ServiceException>>();

    @Override
    public <T extends Throwable, U extends ServiceException> void map(Class<T> inExceptionClass, Class<U> outExceptionClass) {
        this.exceptions.put(inExceptionClass, outExceptionClass);
    }

    @Override
    public ServiceException getExceptionFor(Throwable throwable) {
        Throwable from = this.getMappableThrowable(throwable);
        Class<? extends ServiceException> mapped = this.exceptions.get(from.getClass());
        if (mapped != null) {
            try {
                Constructor<? extends ServiceException> constructor = mapped.getConstructor(String.class, Throwable.class);
                return constructor.newInstance(from.getMessage(), throwable);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private Throwable getMappableThrowable(Throwable throwable) {
        Throwable cause;
        Throwable mappable = throwable;
        if (RuntimeException.class.equals(throwable.getClass()) && (cause = throwable.getCause()) != null) {
            mappable = cause;
        }
        return mappable;
    }
}

