/*
 * Decompiled with CFR 0.152.
 */
package org.restexpress.contenttype;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.restexpress.contenttype.MediaRange;

public class MediaTypeParser {
    public static List<MediaRange> parse(String mediaType) {
        if (mediaType == null) {
            return Collections.emptyList();
        }
        String[] segments = mediaType.split("\\s*,\\s*");
        ArrayList<MediaRange> items = new ArrayList<MediaRange>();
        for (String segment : segments) {
            items.add(MediaRange.parse(segment));
        }
        return items;
    }

    public static String getBestMatch(List<MediaRange> supportedRanges, List<MediaRange> requestedRanges) {
        ArrayList<WeightedMatch> matches = new ArrayList<WeightedMatch>();
        for (MediaRange supportedRange : supportedRanges) {
            WeightedMatch m = MediaTypeParser.getWeightedMatch(supportedRange, requestedRanges);
            if (m == null) continue;
            matches.add(m);
        }
        if (matches.isEmpty()) {
            return null;
        }
        if (matches.size() == 1) {
            return ((WeightedMatch)matches.get((int)0)).mediaRange.asMediaType();
        }
        Collections.sort(matches);
        return ((WeightedMatch)matches.get((int)0)).mediaRange.asMediaType();
    }

    private static WeightedMatch getWeightedMatch(MediaRange supportedRange, List<MediaRange> requestedRanges) {
        int maxRank = -1;
        MediaRange bestMatch = null;
        for (MediaRange requestedRange : requestedRanges) {
            int rank = supportedRange.rankAgainst(requestedRange);
            if (rank <= maxRank) continue;
            maxRank = rank;
            bestMatch = supportedRange;
        }
        return maxRank == -1 ? null : new WeightedMatch(bestMatch, maxRank);
    }

    protected static class WeightedMatch
    implements Comparable<WeightedMatch> {
        MediaRange mediaRange;
        int rank;

        public WeightedMatch(MediaRange range, int rank) {
            this.mediaRange = range;
            this.rank = rank;
        }

        public boolean equals(Object that) {
            if (that == null) {
                return false;
            }
            if (this.getClass().isAssignableFrom(that.getClass())) {
                return this.compareTo((WeightedMatch)that) == 0;
            }
            return false;
        }

        public int hashCode() {
            return this.getClass().hashCode() + this.rank + this.mediaRange.hashCode();
        }

        @Override
        public int compareTo(WeightedMatch that) {
            int rankSign = that.rank - this.rank;
            if (rankSign == 0) {
                return (int)((that.mediaRange.qvalue - this.mediaRange.qvalue) * 10.0f);
            }
            return rankSign;
        }
    }
}

