/*
 * Decompiled with CFR 0.152.
 */
package com.strategicgains.hyperexpress.util;

import java.util.HashMap;
import java.util.Map;

public class MapStringFormat {
    private static final String DEFAULT_END_DELIMITER = "}";
    private static final String DEFAULT_START_DELIMITER = "{";
    private String endDelimiter;
    private String startDelimiter;

    public MapStringFormat() {
        this(DEFAULT_START_DELIMITER, DEFAULT_END_DELIMITER);
    }

    public MapStringFormat(String startDelimiter, String endDelimiter) {
        this.startDelimiter(startDelimiter);
        this.endDelimiter(endDelimiter);
    }

    public String endDelimiter() {
        return this.endDelimiter;
    }

    public void endDelimiter(String delimiter) {
        this.endDelimiter = delimiter;
    }

    public String startDelimiter() {
        return this.startDelimiter;
    }

    public void startDelimiter(String delimiter) {
        this.startDelimiter = delimiter;
    }

    public String format(String string, String ... parameters) {
        if (parameters.length % 2 != 0) {
            throw new IllegalArgumentException("Parameters must be in name/value pairs");
        }
        return this.format(string, MapStringFormat.toMap(parameters));
    }

    public String format(String string, Map<String, String> parameters) {
        String result = string;
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            this.constructParameterName(sb, entry.getKey());
            result = result.replaceAll(sb.toString(), entry.getValue());
        }
        return result;
    }

    private String constructParameterName(StringBuilder sb, String key) {
        sb.setLength(0);
        sb.append('\\');
        sb.append(this.startDelimiter());
        sb.append(key);
        sb.append('\\');
        sb.append(this.endDelimiter());
        return sb.toString();
    }

    public static Map<String, String> toMap(String ... nameValuePairs) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (nameValuePairs == null) {
            return result;
        }
        if (nameValuePairs.length % 2 != 0) {
            throw new IllegalArgumentException("Name/value pairs unbalanced: " + nameValuePairs.toString());
        }
        for (int i = 0; i < nameValuePairs.length; i += 2) {
            result.put(nameValuePairs[i], nameValuePairs[i + 1]);
        }
        return result;
    }
}

