/*
 * Decompiled with CFR 0.152.
 */
package com.strategicgains.hyperexpress.domain;

import com.strategicgains.hyperexpress.domain.Link;
import com.strategicgains.hyperexpress.domain.LinkDefinition;
import com.strategicgains.hyperexpress.domain.Namespace;
import com.strategicgains.hyperexpress.domain.Resource;
import com.strategicgains.hyperexpress.exception.ResourceException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractResource
implements Resource {
    private List<Namespace> namespaces;
    private Map<String, List<Link>> linksByRel = new LinkedHashMap<String, List<Link>>();
    private List<Link> allLinks = new ArrayList<Link>();
    private Map<String, Object> properties = new LinkedHashMap<String, Object>();
    private Map<String, List<Resource>> resources;
    private Set<String> arrayLinkRels = new HashSet<String>();
    private Set<String> arrayResourceRels = new HashSet<String>();

    @Override
    public Resource from(Resource that) {
        this.addNamespaces(that.getNamespaces());
        this.addLinks(that.getLinks());
        for (Map.Entry<String, Object> entry : that.getProperties().entrySet()) {
            this.addProperty(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : that.getResources().entrySet()) {
            this.addResources(entry.getKey(), (Collection)entry.getValue());
        }
        return this;
    }

    @Override
    public Resource addProperty(String name, Object value) {
        if (this.properties.containsKey(name)) {
            throw new ResourceException("Duplicate property: " + name);
        }
        this.properties.put(name, value);
        return this;
    }

    @Override
    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    @Override
    public Resource setProperty(String key, Object value) {
        if (value != null) {
            this.properties.put(key, value);
        } else {
            this.properties.remove(key);
        }
        return this;
    }

    @Override
    public Resource addLink(String rel, String url) {
        return this.addLink(rel, url, false);
    }

    @Override
    public Resource addLink(String rel, String url, boolean isMultiple) {
        return this.addLink(new LinkDefinition(rel, url), isMultiple);
    }

    @Override
    public Resource addNamespace(String name, String href) {
        return this.addNamespace(new Namespace(name, href));
    }

    @Override
    public Resource addNamespace(Namespace namespace) {
        if (namespace == null) {
            throw new ResourceException("Cannot add null namespace");
        }
        if (this.namespaces == null) {
            this.namespaces = new ArrayList<Namespace>();
        }
        if (!this.namespaces.contains(namespace)) {
            this.namespaces.add(namespace);
        }
        return this;
    }

    @Override
    public Resource addNamespaces(Collection<Namespace> values) {
        if (values == null) {
            return this;
        }
        for (Namespace ns : values) {
            this.addNamespace(ns);
        }
        return this;
    }

    @Override
    public List<Namespace> getNamespaces() {
        return this.namespaces == null ? Collections.emptyList() : Collections.unmodifiableList(this.namespaces);
    }

    @Override
    public boolean hasNamespaces() {
        return this.namespaces != null && !this.namespaces.isEmpty();
    }

    @Override
    public Map<String, Object> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    @Override
    public boolean hasProperties() {
        return !this.properties.isEmpty();
    }

    @Override
    public Resource addLink(Link link) {
        return this.addLink(link, false);
    }

    @Override
    public Resource addLink(Link link, boolean isMultiple) {
        if (link == null) {
            throw new ResourceException("Cannot add null link");
        }
        if (link.getRel() == null) {
            throw new ResourceException("Cannot link with null 'rel'");
        }
        this.acquireLinksForRel(link.getRel()).add(link);
        this.allLinks.add(link);
        if (isMultiple) {
            this.arrayLinkRels.add(link.getRel());
        }
        return this;
    }

    @Override
    public Resource addLinks(Collection<Link> links) {
        if (links == null) {
            throw new ResourceException("Cannot add null links collection to resource");
        }
        for (Link link : links) {
            this.addLink(link);
        }
        return this;
    }

    @Override
    public List<Link> getLinks() {
        return Collections.unmodifiableList(this.allLinks);
    }

    public Map<String, List<Link>> getLinksByRel() {
        return Collections.unmodifiableMap(this.linksByRel);
    }

    @Override
    public boolean hasLinks() {
        return !this.linksByRel.isEmpty();
    }

    @Override
    public Resource addResource(String rel, Resource resource) {
        return this.addResource(rel, resource, false);
    }

    @Override
    public Resource addResource(String rel, Resource resource, boolean isMultiple) {
        if (rel == null) {
            throw new ResourceException("Cannot embed resource using null 'rel'");
        }
        if (resource == null) {
            throw new ResourceException("Cannot embed null resource");
        }
        List<Resource> forRel = this.acquireResourcesForRel(rel);
        forRel.add(resource);
        if (isMultiple) {
            this.arrayResourceRels.add(rel);
        }
        return this;
    }

    @Override
    public Resource addResources(String rel, Collection<Resource> collection) {
        List<Resource> forRel = this.acquireResourcesForRel(rel);
        forRel.addAll(collection);
        this.arrayResourceRels.add(rel);
        return this;
    }

    @Override
    public Map<String, List<Resource>> getResources() {
        return Collections.unmodifiableMap(this._getResources());
    }

    private Map<String, List<Resource>> _getResources() {
        return this.resources == null ? Collections.emptyMap() : this.resources;
    }

    @Override
    public List<Resource> getResources(String rel) {
        List<Resource> result = this._getResources().get(rel);
        return result == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(result);
    }

    @Override
    public boolean hasResources() {
        return this.resources != null && !this.resources.isEmpty();
    }

    private List<Resource> acquireResourcesForRel(String rel) {
        List<Resource> forRel;
        if (this.resources == null) {
            this.resources = new HashMap<String, List<Resource>>();
        }
        if ((forRel = this.resources.get(rel)) == null) {
            forRel = new ArrayList<Resource>();
            this.resources.put(rel, forRel);
        }
        return forRel;
    }

    private List<Link> acquireLinksForRel(String rel) {
        List<Link> forRel = this.linksByRel.get(rel);
        if (forRel == null) {
            forRel = new ArrayList<Link>();
            this.linksByRel.put(rel, forRel);
        }
        return forRel;
    }

    @Override
    public boolean isMultipleLinks(String rel) {
        return this.arrayLinkRels.contains(rel);
    }

    @Override
    public boolean isMultipleResources(String rel) {
        return this.arrayResourceRels.contains(rel);
    }

    @Override
    public Object removeProperty(String name) {
        return this.properties.remove(name);
    }

    @Override
    public boolean hasResources(String rel) {
        return this._getResources().containsKey(rel);
    }

    @Override
    public boolean hasProperty(String name) {
        return this.properties.containsKey(name);
    }
}

