/*
 * Decompiled with CFR 0.152.
 */
package com.strategicgains.hyperexpress.builder;

import com.strategicgains.hyperexpress.builder.DefaultUrlBuilder;
import com.strategicgains.hyperexpress.builder.LinkBuilder;
import com.strategicgains.hyperexpress.builder.TokenResolver;
import com.strategicgains.hyperexpress.builder.UrlBuilder;
import com.strategicgains.hyperexpress.domain.Link;
import com.strategicgains.hyperexpress.domain.LinkDefinition;
import java.util.HashMap;
import java.util.Map;

public class DefaultLinkBuilder
implements LinkBuilder {
    private static final String REL_TYPE = "rel";
    private static final String TITLE = "title";
    private static final String TYPE = "type";
    private UrlBuilder urlBuilder;
    private Map<String, String> attributes = new HashMap<String, String>();

    public DefaultLinkBuilder() {
        this.urlBuilder = new DefaultUrlBuilder();
    }

    public DefaultLinkBuilder(String urlPattern) {
        this.urlBuilder = new DefaultUrlBuilder(urlPattern);
    }

    public DefaultLinkBuilder(DefaultLinkBuilder that) {
        this.urlBuilder = that.urlBuilder.clone();
        this.attributes = new HashMap<String, String>(that.attributes);
    }

    @Override
    public DefaultLinkBuilder baseUrl(String url) {
        this.urlBuilder.baseUrl(url);
        return this;
    }

    @Override
    public DefaultLinkBuilder withQuery(String query) {
        this.urlBuilder.withQuery(query);
        return this;
    }

    @Override
    public void clearAttributes() {
        this.attributes.clear();
    }

    @Override
    public void clearQueries() {
        this.urlBuilder.clearQueries();
    }

    @Override
    public String urlPattern() {
        return this.urlBuilder.urlPattern();
    }

    @Override
    public DefaultLinkBuilder urlPattern(String pattern) {
        this.urlBuilder.urlPattern(pattern);
        return this;
    }

    @Override
    public DefaultLinkBuilder rel(String rel) {
        return this.set(REL_TYPE, rel);
    }

    @Override
    public String rel() {
        return this.get(REL_TYPE);
    }

    @Override
    public DefaultLinkBuilder title(String title) {
        return this.set(TITLE, title);
    }

    @Override
    public String title() {
        return this.get(TITLE);
    }

    @Override
    public DefaultLinkBuilder type(String type) {
        return this.set(TYPE, type);
    }

    @Override
    public String type() {
        return this.get(TYPE);
    }

    @Override
    public String get(String name) {
        return this.attributes.get(name);
    }

    @Override
    public DefaultLinkBuilder set(String name, String value) {
        if (value == null) {
            this.attributes.remove(name);
        } else {
            this.attributes.put(name, value);
        }
        return this;
    }

    @Override
    public Link build() {
        return this.build(null);
    }

    @Override
    public Link build(TokenResolver tokenResolver) {
        return this.createLink(this.urlBuilder.build(tokenResolver));
    }

    @Override
    public Link build(Object object, TokenResolver tokenResolver) {
        return this.createLink(this.urlBuilder.build(object, tokenResolver));
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(this.getClass().getSimpleName());
        s.append("{");
        boolean isFirst = true;
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            if (!isFirst) {
                s.append(", ");
            } else {
                isFirst = false;
            }
            s.append(entry.getKey());
            s.append("=");
            s.append(entry.getValue());
        }
        s.append("}");
        return s.toString();
    }

    private Link createLink(String url) {
        LinkDefinition link = new LinkDefinition(this.attributes.get(REL_TYPE), url);
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            if (entry.getKey().equalsIgnoreCase(REL_TYPE)) continue;
            link.set(entry.getKey(), entry.getValue());
        }
        return link;
    }
}

