/*
 * Decompiled with CFR 0.152.
 */
package com.strategicgains.hyperexpress;

import com.strategicgains.hyperexpress.ResourceFactory;
import com.strategicgains.hyperexpress.ResourceFactoryStrategy;
import com.strategicgains.hyperexpress.domain.Resource;
import com.strategicgains.hyperexpress.exception.ResourceException;
import java.util.HashMap;
import java.util.Map;

public class DefaultResourceFactory
implements ResourceFactory {
    private Map<String, ResourceFactoryStrategy> factoryStrategies = new HashMap<String, ResourceFactoryStrategy>();

    @Override
    public Resource createResource(Object object, String contentType) {
        ResourceFactoryStrategy strategy = this.factoryStrategies.get(contentType);
        if (strategy == null) {
            throw new ResourceException("Cannot create resource for content type: " + contentType);
        }
        return strategy.createResource(object);
    }

    public DefaultResourceFactory addFactoryStrategy(ResourceFactoryStrategy strategy, String contentType) {
        if (this.factoryStrategies.containsKey(contentType)) {
            throw new ResourceException("Duplicate content type: " + contentType);
        }
        this.factoryStrategies.put(contentType, strategy);
        return this;
    }

    @Override
    public Class<? extends Resource> getResourceType(String contentType) {
        ResourceFactoryStrategy strategy = this.factoryStrategies.get(contentType);
        if (strategy == null) {
            throw new ResourceException("No resource factory for content type: " + contentType);
        }
        return strategy.getResourceType();
    }
}

