/*
 * Decompiled with CFR 0.152.
 */
package com.strategicgains.util.date;

import com.strategicgains.util.AdapterCallback;
import com.strategicgains.util.TextAdapter;
import com.strategicgains.util.date.DateAdapterConstants;
import com.strategicgains.util.date.DateFormatProcessor;
import java.text.ParseException;
import java.util.Date;

public class DateAdapter
implements TextAdapter<Date> {
    private DateFormatProcessor processor;
    private AdapterCallback<String> preParseCallback = null;
    private AdapterCallback<Date> postParseCallback = null;
    private AdapterCallback<Date> preFormatCallback = null;
    private AdapterCallback<String> postFormatCallback = null;

    public DateAdapter() {
        this("yyyy-MM-dd", DateAdapterConstants.DATE_INPUT_FORMATS);
    }

    protected DateAdapter(String outputFormat, String ... inputFormats) {
        this.processor = new DateFormatProcessor(outputFormat, inputFormats);
    }

    public void setPreParseCallback(AdapterCallback<String> preParseCallback) {
        this.preParseCallback = preParseCallback;
    }

    public void setPostParseCallback(AdapterCallback<Date> postParseCallback) {
        this.postParseCallback = postParseCallback;
    }

    public void setPreFormatCallback(AdapterCallback<Date> preFormatCallback) {
        this.preFormatCallback = preFormatCallback;
    }

    public void setPostFormatCallback(AdapterCallback<String> postFormatCallback) {
        this.postFormatCallback = postFormatCallback;
    }

    @Override
    public Date parse(String dateString) throws ParseException {
        String preprocessed = this.beforeParse(dateString);
        Date date = this.processor.parse(preprocessed);
        return this.afterParse(date);
    }

    @Override
    public String format(Date date) {
        Date preprocessed = this.beforeFormat(date);
        String string = this.processor.format(preprocessed);
        return this.afterFormat(string);
    }

    protected String beforeParse(String string) {
        if (this.preParseCallback == null) {
            return string;
        }
        return this.preParseCallback.process(string);
    }

    protected Date beforeFormat(Date date) {
        if (this.preFormatCallback == null) {
            return date;
        }
        return this.preFormatCallback.process(date);
    }

    protected Date afterParse(Date date) {
        if (this.postParseCallback == null) {
            return date;
        }
        return this.postParseCallback.process(date);
    }

    protected String afterFormat(String string) {
        if (this.postFormatCallback == null) {
            return string;
        }
        return this.postFormatCallback.process(string);
    }
}

