/*
 * Decompiled with CFR 0.152.
 */
package org.scalameter.execution;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.scalameter.Context;
import org.scalameter.Key$;
import org.scalameter.KeyWithDefault;
import org.scalameter.execution.Main;
import org.scalameter.execution.SeparateJvmFailure;
import org.scalameter.package;
import org.scalameter.package$;
import org.scalameter.utils.ClassPath;
import scala.Function0;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005M4A!\u0003\u0006\u0003#!)\u0001\u0004\u0001C\u00013!9A\u0004\u0001b\u0001\n\u0013i\u0002B\u0002\u0014\u0001A\u0003%a\u0004C\u0003(\u0001\u0011\u0005\u0001\u0006C\u0003H\u0001\u0011%\u0001\nC\u0003S\u0001\u0011\u00051\u000bC\u0003j\u0001\u0011%!\u000eC\u0003m\u0001\u0011%QNA\u0005Km6\u0014VO\u001c8fe*\u00111\u0002D\u0001\nKb,7-\u001e;j_:T!!\u0004\b\u0002\u0015M\u001c\u0017\r\\1nKR,'OC\u0001\u0010\u0003\ry'oZ\u0002\u0001'\t\u0001!\u0003\u0005\u0002\u0014-5\tACC\u0001\u0016\u0003\u0015\u00198-\u00197b\u0013\t9BC\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003i\u0001\"a\u0007\u0001\u000e\u0003)\tq\u0001^7qM&dW-F\u0001\u001f!\tyB%D\u0001!\u0015\t\t#%\u0001\u0002j_*\t1%\u0001\u0003kCZ\f\u0017BA\u0013!\u0005\u00111\u0015\u000e\\3\u0002\u0011Ql\u0007OZ5mK\u0002\n1A];o+\tI3\u0007\u0006\u0002+\u0003R\u00111\u0006\u0010\t\u0004Y=\nT\"A\u0017\u000b\u00059\"\u0012\u0001B;uS2L!\u0001M\u0017\u0003\u0007Q\u0013\u0018\u0010\u0005\u00023g1\u0001A!\u0002\u001b\u0005\u0005\u0004)$!\u0001*\u0012\u0005YJ\u0004CA\n8\u0013\tADCA\u0004O_RD\u0017N\\4\u0011\u0005MQ\u0014BA\u001e\u0015\u0005\r\te.\u001f\u0005\u0007{\u0011!\t\u0019\u0001 \u0002\t\t|G-\u001f\t\u0004'}\n\u0014B\u0001!\u0015\u0005!a$-\u001f8b[\u0016t\u0004\"\u0002\"\u0005\u0001\u0004\u0019\u0015aA2uqB\u0011A)R\u0007\u0002\u0019%\u0011a\t\u0004\u0002\b\u0007>tG/\u001a=u\u00039\u0019XM]5bY&TX-\u00138qkR,\"!\u0013)\u0015\u0005)k\u0005CA\nL\u0013\taEC\u0001\u0003V]&$\b\"\u0002(\u0006\u0001\u0004y\u0015AB2p]\u001aLw\r\u0005\u00023!\u0012)\u0011+\u0002b\u0001k\t\tA+\u0001\u0006d_6l\u0017M\u001c3G_J$\"\u0001\u00165\u0011\u0007Uk\u0006M\u0004\u0002W7:\u0011qKW\u0007\u00021*\u0011\u0011\fE\u0001\u0007yI|w\u000e\u001e \n\u0003UI!\u0001\u0018\u000b\u0002\u000fA\f7m[1hK&\u0011al\u0018\u0002\u0004'\u0016\f(B\u0001/\u0015!\t\tWM\u0004\u0002cGB\u0011q\u000bF\u0005\u0003IR\ta\u0001\u0015:fI\u00164\u0017B\u00014h\u0005\u0019\u0019FO]5oO*\u0011A\r\u0006\u0005\u0006\u0005\u001a\u0001\raQ\u0001\u0007eVt'J^7\u0015\u0005)[\u0007\"\u0002\"\b\u0001\u0004\u0019\u0015A\u0003:fC\u0012|U\u000f\u001e9viV\u0011a.\u001d\u000b\u0003_J\u00042\u0001L\u0018q!\t\u0011\u0014\u000fB\u00035\u0011\t\u0007Q\u0007C\u0003C\u0011\u0001\u00071\t")
public final class JvmRunner {
    private final File tmpfile = File.createTempFile("newjvm-", "-io");

    private File tmpfile() {
        return this.tmpfile;
    }

    public <R> Try<R> run(Context ctx2, Function0<R> body) {
        this.serializeInput(body);
        this.runJvm(ctx2);
        return this.readOutput(ctx2);
    }

    private <T> void serializeInput(T config) {
        FileOutputStream fos = new FileOutputStream(this.tmpfile());
        ObjectOutputStream oos = new ObjectOutputStream(fos);
        try {
            oos.writeObject(config);
        }
        finally {
            fos.close();
            oos.close();
        }
    }

    public Seq<String> commandFor(Context ctx2) {
        ClassPath classpath = (ClassPath)ctx2.apply((KeyWithDefault)Key$.MODULE$.finalClasspath());
        List flags = (List)ctx2.apply((KeyWithDefault)Key$.MODULE$.exec().jvmflags());
        String jcmd = (String)ctx2.apply((KeyWithDefault)Key$.MODULE$.exec().jvmcmd());
        Seq command = (Seq)((IterableOps)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{jcmd, "-server"})).$plus$plus((IterableOnce)flags)).$plus$plus((IterableOnce)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"-cp", classpath.mkString(), Main.class.getName(), this.tmpfile().getPath()})));
        return command;
    }

    private void runJvm(Context ctx2) {
        Seq<String> command = this.commandFor(ctx2);
        package.dyn$.MODULE$.currentContext().withValue((Object)ctx2, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            package$.MODULE$.log().currentBegin();
            package$.MODULE$.log().info(new StringBuilder(18).append("Starting new JVM: ").append(command.mkString(" ")).toString());
        });
        ProcessBuilder pb = new ProcessBuilder((String[])command.toArray(ClassTag$.MODULE$.apply(String.class)));
        pb.redirectInput(ProcessBuilder.Redirect.INHERIT);
        pb.redirectOutput(ProcessBuilder.Redirect.INHERIT);
        pb.redirectError(ProcessBuilder.Redirect.INHERIT);
        pb.start().waitFor();
        package$.MODULE$.log().clear();
    }

    private <R> Try<R> readOutput(Context ctx2) {
        Success success;
        FileInputStream fis = new FileInputStream(this.tmpfile());
        ObjectInputStream ois = new ObjectInputStream(fis);
        try {
            Success success2;
            Object result;
            ClassPath cl = (ClassPath)ctx2.apply((KeyWithDefault)Key$.MODULE$.finalClasspath());
            Object object = result = ois.readObject();
            if (object instanceof SeparateJvmFailure) {
                SeparateJvmFailure separateJvmFailure = (SeparateJvmFailure)object;
                Throwable t = separateJvmFailure.t();
                success2 = new Failure(t);
            } else {
                success2 = new Success(object);
            }
            success = success2;
        }
        finally {
            fis.close();
            ois.close();
        }
        return success;
    }

    public JvmRunner() {
        this.tmpfile().deleteOnExit();
    }
}

