/*
 * Decompiled with CFR 0.152.
 */
package com.starburstdata.docker.$internal.org.glassfish.hk2.utilities.general;

import java.util.HashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class Hk2ThreadLocal<T> {
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.WriteLock wLock = this.readWriteLock.writeLock();
    private final ReentrantReadWriteLock.ReadLock rLock = this.readWriteLock.readLock();
    private final HashMap<Long, T> locals = new HashMap();

    protected T initialValue() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get() {
        long id = Thread.currentThread().getId();
        this.rLock.lock();
        try {
            if (this.locals.containsKey(id)) {
                T t = this.locals.get(id);
                return t;
            }
        }
        finally {
            this.rLock.unlock();
        }
        this.wLock.lock();
        try {
            if (this.locals.containsKey(id)) {
                T t = this.locals.get(id);
                return t;
            }
            T initialValue = this.initialValue();
            this.locals.put(id, initialValue);
            T t = initialValue;
            return t;
        }
        finally {
            this.wLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(T value) {
        long id = Thread.currentThread().getId();
        this.wLock.lock();
        try {
            this.locals.put(id, value);
        }
        finally {
            this.wLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove() {
        long id = Thread.currentThread().getId();
        this.wLock.lock();
        try {
            this.locals.remove(id);
        }
        finally {
            this.wLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        this.wLock.lock();
        try {
            this.locals.clear();
        }
        finally {
            this.wLock.unlock();
        }
    }
}

