/*
 * Decompiled with CFR 0.152.
 */
package com.starburstdata.docker.$internal.jnr.unixsocket;

import com.starburstdata.docker.$internal.jnr.constants.platform.ProtocolFamily;
import com.starburstdata.docker.$internal.jnr.constants.platform.Sock;
import com.starburstdata.docker.$internal.jnr.enxio.channels.NativeServerSocketChannel;
import com.starburstdata.docker.$internal.jnr.ffi.byref.IntByReference;
import com.starburstdata.docker.$internal.jnr.unixsocket.Native;
import com.starburstdata.docker.$internal.jnr.unixsocket.SockAddrUnix;
import com.starburstdata.docker.$internal.jnr.unixsocket.UnixServerSocket;
import com.starburstdata.docker.$internal.jnr.unixsocket.UnixSocketAddress;
import com.starburstdata.docker.$internal.jnr.unixsocket.UnixSocketChannel;
import java.io.IOException;
import java.nio.channels.spi.SelectorProvider;

public class UnixServerSocketChannel
extends NativeServerSocketChannel {
    private final UnixServerSocket socket = new UnixServerSocket(this);

    UnixServerSocketChannel(UnixServerSocket socket) throws IOException {
        super(Native.socket(ProtocolFamily.PF_UNIX, Sock.SOCK_STREAM, 0));
    }

    UnixServerSocketChannel(SelectorProvider provider, int fd) {
        super(provider, fd, 17);
    }

    public static UnixServerSocketChannel open() throws IOException {
        return new UnixServerSocket().channel;
    }

    public UnixSocketChannel accept() throws IOException {
        UnixSocketAddress remote = new UnixSocketAddress();
        SockAddrUnix addr = remote.getStruct();
        int maxLength = addr.getMaximumLength();
        IntByReference len = new IntByReference(maxLength);
        int clientfd = Native.accept(this.getFD(), addr, len);
        if (clientfd < 0) {
            if (this.isBlocking()) {
                throw new IOException("accept failed: " + Native.getLastErrorString());
            }
            return null;
        }
        addr.updatePath((Integer)len.getValue());
        Native.setBlocking(clientfd, true);
        return new UnixSocketChannel(clientfd);
    }

    public final UnixServerSocket socket() {
        return this.socket;
    }

    public final UnixSocketAddress getRemoteSocketAddress() {
        return null;
    }

    public final UnixSocketAddress getLocalSocketAddress() {
        return this.socket.localAddress;
    }
}

