/*
 * Decompiled with CFR 0.152.
 */
package com.starburstdata.docker.$internal.jnr.posix.util;

import com.starburstdata.docker.$internal.jnr.ffi.Memory;
import com.starburstdata.docker.$internal.jnr.ffi.Pointer;
import com.starburstdata.docker.$internal.jnr.ffi.Runtime;
import com.starburstdata.docker.$internal.jnr.posix.POSIX;
import com.starburstdata.docker.$internal.jnr.posix.util.Finder;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class WindowsHelpers {
    static final Runtime runtime = Runtime.getSystemRuntime();
    static final int WORDSIZE = Runtime.getSystemRuntime().addressSize();
    private static final String COMMAND_DOT_COM = "command.com";
    private static final int CDC_LENGTH = "command.com".length();
    private static Map<String, InternalType> INTERNAL_COMMANDS = new HashMap<String, InternalType>(){
        {
            this.put("assoc", InternalType.COMMAND);
            this.put("break", InternalType.BOTH);
            this.put("call", InternalType.BOTH);
            this.put("cd", InternalType.BOTH);
            this.put("chcp", InternalType.SHELL);
            this.put("chdir", InternalType.BOTH);
            this.put("cls", InternalType.BOTH);
            this.put("color", InternalType.COMMAND);
            this.put("copy", InternalType.BOTH);
            this.put("ctty", InternalType.SHELL);
            this.put("date", InternalType.BOTH);
            this.put("del", InternalType.BOTH);
            this.put("dir", InternalType.BOTH);
            this.put("echo", InternalType.BOTH);
            this.put("endlocal", InternalType.COMMAND);
            this.put("erase", InternalType.BOTH);
            this.put("exit", InternalType.BOTH);
            this.put("for", InternalType.BOTH);
            this.put("ftype", InternalType.COMMAND);
            this.put("goto", InternalType.BOTH);
            this.put("if", InternalType.BOTH);
            this.put("lfnfor", InternalType.SHELL);
            this.put("lh", InternalType.SHELL);
            this.put("lock", InternalType.SHELL);
            this.put("md", InternalType.BOTH);
            this.put("mkdir", InternalType.BOTH);
            this.put("move", InternalType.COMMAND);
            this.put("path", InternalType.BOTH);
            this.put("pause", InternalType.BOTH);
            this.put("popd", InternalType.COMMAND);
            this.put("prompt", InternalType.BOTH);
            this.put("pushd", InternalType.COMMAND);
            this.put("rd", InternalType.BOTH);
            this.put("rem", InternalType.BOTH);
            this.put("ren", InternalType.BOTH);
            this.put("rename", InternalType.BOTH);
            this.put("rmdir", InternalType.BOTH);
            this.put("set", InternalType.BOTH);
            this.put("setlocal", InternalType.COMMAND);
            this.put("shift", InternalType.BOTH);
            this.put("start", InternalType.COMMAND);
            this.put("time", InternalType.BOTH);
            this.put("title", InternalType.COMMAND);
            this.put("truename", InternalType.SHELL);
            this.put("type", InternalType.BOTH);
            this.put("unlock", InternalType.SHELL);
            this.put("ver", InternalType.BOTH);
            this.put("verify", InternalType.BOTH);
            this.put("vol", InternalType.BOTH);
        }
    };

    public static byte[] toWPath(String path) {
        return WindowsHelpers.toWString(path);
    }

    public static byte[] toWString(String string) {
        if (string == null) {
            return null;
        }
        string = string + '\u0000';
        try {
            return string.getBytes("UTF-16LE");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static Pointer createWideEnv(String[] envp) {
        if (envp == null) {
            return null;
        }
        byte[] marker = new byte[]{0};
        int envLength = envp.length;
        Pointer result = Memory.allocateDirect(runtime, WORDSIZE * (envLength + 1));
        for (int i = 0; i < envLength; ++i) {
            byte[] bytes = WindowsHelpers.toWString(envp[i]);
            Pointer envElement = Memory.allocateDirect(runtime, bytes.length + 1);
            envElement.put(0L, bytes, 0, bytes.length);
            envElement.put((long)bytes.length, marker, 0, marker.length);
            result.putPointer(i * WORDSIZE, envElement);
        }
        Pointer nullMarker = Memory.allocateDirect(runtime, marker.length);
        nullMarker.put(0L, marker, 0, marker.length);
        result.putPointer(WORDSIZE * envLength, nullMarker);
        return result;
    }

    private static void joinSingleArgv(StringBuilder buffer, String arg, boolean quote, boolean escape) {
        int backslashCount = 0;
        int start = 0;
        if (quote) {
            buffer.append('\"');
        }
        block5: for (int i = 0; i < arg.length(); ++i) {
            char c = arg.charAt(i);
            switch (c) {
                case '\\': {
                    ++backslashCount;
                    continue block5;
                }
                case '\"': {
                    buffer.append(arg.substring(start, i));
                    for (int j = 0; j < backslashCount + 1; ++j) {
                        buffer.append('\\');
                    }
                    backslashCount = 0;
                    start = i;
                }
                case '<': 
                case '>': 
                case '^': 
                case '|': {
                    if (escape && !quote) {
                        buffer.append(arg.substring(start, i));
                        buffer.append('^');
                        start = i;
                        continue block5;
                    }
                }
                default: {
                    backslashCount = 0;
                }
            }
        }
        buffer.append(arg.substring(start));
        if (quote) {
            buffer.append('\"');
        }
    }

    public static String joinArgv(String command, String[] argv, boolean escape) {
        StringBuilder buffer = new StringBuilder();
        if (command != null) {
            buffer.append(command);
            buffer.append(' ');
        }
        int last_index = argv.length - 1;
        for (int i = 0; i <= last_index; ++i) {
            WindowsHelpers.joinSingleArgv(buffer, argv[i], WindowsHelpers.quotable(argv[i]), escape);
            if (i == last_index) continue;
            buffer.append(' ');
        }
        return buffer.toString();
    }

    public static boolean quotable(String value) {
        if (value == null) {
            return false;
        }
        StringTokenizer toker = new StringTokenizer(value, " \t\"'");
        toker.nextToken();
        return toker.hasMoreTokens();
    }

    public static boolean isBatch(String value) {
        if (value == null) {
            return false;
        }
        int length = value.length();
        if (length < 5) {
            return false;
        }
        String end = value.substring(length - 4);
        return end.equalsIgnoreCase(".bat") || end.equalsIgnoreCase(".cmd");
    }

    public static String[] processCommandLine(POSIX posix, String command, String program, String path) {
        String shell = null;
        if (program != null) {
            String fullPath = Finder.findFileInPath(posix, program, path);
            shell = fullPath == null ? program : fullPath.replace('/', '\\');
        } else {
            command = command.substring(WindowsHelpers.firstNonWhitespaceIndex(command));
            shell = System.getenv("COMSPEC");
            boolean notHandledYet = true;
            if (shell != null) {
                boolean commandDotCom = WindowsHelpers.isCommandDotCom(shell);
                if (WindowsHelpers.hasBuiltinSpecialNeeds(command) || WindowsHelpers.isInternalCommand(command, commandDotCom)) {
                    String quote = commandDotCom ? "\"" : "";
                    command = shell + " /c " + quote + command + quote;
                    notHandledYet = false;
                }
            }
            if (notHandledYet) {
                int i;
                char firstChar = command.charAt(0);
                char quote = firstChar == '\"' ? firstChar : (firstChar == '\'' ? firstChar : (char)'\u0000');
                int commandLength = command.length();
                int n = i = quote == '\u0000' ? 0 : 1;
                while (true) {
                    if (i == commandLength) {
                        shell = command;
                        break;
                    }
                    char c = command.charAt(i);
                    if (c == quote) {
                        shell = command.substring(1, i);
                        break;
                    }
                    if (quote == '\u0000' && (Character.isSpaceChar(c) || WindowsHelpers.isFunnyChar(c))) {
                        shell = command.substring(0, i);
                        break;
                    }
                    ++i;
                }
                shell = Finder.findFileInPath(posix, shell, path);
                if (shell == null) {
                    shell = command.substring(0, i);
                } else {
                    if (!shell.contains(" ")) {
                        quote = '\u0000';
                    }
                    shell = shell.replace('/', '\\');
                }
            }
        }
        return new String[]{command, shell};
    }

    public static String[] processCommandArgs(POSIX posix, String program, String[] argv, String path) {
        boolean commandDotCom;
        if (program == null || program.length() == 0) {
            program = argv[0];
        }
        boolean addSlashC = false;
        boolean isNotBuiltin = false;
        boolean notHandledYet = true;
        String shell = System.getenv("COMSPEC");
        String command = null;
        if (shell != null && WindowsHelpers.isInternalCommand(program, commandDotCom = WindowsHelpers.isCommandDotCom(shell))) {
            isNotBuiltin = !commandDotCom;
            program = shell;
            addSlashC = true;
            notHandledYet = false;
        }
        if (notHandledYet) {
            command = Finder.findFileInPath(posix, program, path);
            if (command != null) {
                program = command.replace('/', '\\');
            } else if (program.contains("/")) {
                program = command = program.replace('/', '\\');
            }
        }
        if (addSlashC || WindowsHelpers.isBatch(program)) {
            if (addSlashC) {
                command = program + " /c ";
            } else {
                String[] newArgv = new String[argv.length - 1];
                System.arraycopy(argv, 1, newArgv, 0, argv.length - 1);
                argv = newArgv;
            }
            if (argv.length > 0) {
                command = WindowsHelpers.joinArgv(command, argv, isNotBuiltin);
            }
            program = addSlashC ? shell : null;
        } else {
            command = WindowsHelpers.joinArgv(null, argv, false);
        }
        return new String[]{command, program};
    }

    private static boolean isFunnyChar(char c) {
        return c == '<' || c == '>' || c == '|' || c == '*' || c == '?' || c == '\"';
    }

    private static boolean hasBuiltinSpecialNeeds(String value) {
        int length = value.length();
        char quote = '\u0000';
        block5: for (int i = 0; i < length; ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\"': 
                case '\'': {
                    if (quote == '\u0000') {
                        quote = c;
                        continue block5;
                    }
                    if (quote != c) continue block5;
                    quote = '\u0000';
                    continue block5;
                }
                case '\n': 
                case '<': 
                case '>': 
                case '|': {
                    if (quote == '\u0000') continue block5;
                    return true;
                }
                case '%': {
                    char c2;
                    if (i + 1 >= length || (c2 = value.charAt(++i)) != ' ' && !Character.isLetter(c2)) continue block5;
                    for (int j = i; j < length && ((c2 = value.charAt(j)) == ' ' || Character.isLetterOrDigit(c2)); ++j) {
                    }
                    if (c2 != '%') continue block5;
                    return true;
                }
            }
        }
        return false;
    }

    private static int firstNonWhitespaceIndex(String value) {
        int i;
        int length = value.length();
        for (i = 0; i < length && Character.isSpaceChar(value.charAt(i)); ++i) {
        }
        return i;
    }

    public static String escapePath(String path) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            buf.append(c);
            if (c != '\\') continue;
            buf.append(c);
        }
        return buf.toString() + "\\\\";
    }

    private static boolean isDirectorySeparator(char value) {
        return value == '/' || value == '\\';
    }

    private static boolean isCommandDotCom(String command) {
        int length = command.length();
        int i = length - CDC_LENGTH;
        return i == 0 || i > 0 && WindowsHelpers.isDirectorySeparator(command.charAt(i - 1)) && command.regionMatches(true, i, COMMAND_DOT_COM, 0, CDC_LENGTH);
    }

    private static boolean isInternalCommand(String command, boolean hasCommandDotCom) {
        InternalType kindOf;
        int i;
        assert (command != null && !Character.isSpaceChar(command.charAt(0))) : "Spaces should have been stripped off already";
        int length = command.length();
        StringBuilder buf = new StringBuilder();
        char c = '\u0000';
        for (i = 0; i < length && Character.isLetter(c = command.charAt(i)); ++i) {
            buf.append(Character.toLowerCase(c));
        }
        if (i < length) {
            if (c == '.' && i + 1 < length) {
                ++i;
            }
            switch (command.charAt(i)) {
                case '<': 
                case '>': 
                case '|': {
                    return true;
                }
                case '\u0000': 
                case '\t': 
                case '\n': 
                case ' ': {
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        return (kindOf = INTERNAL_COMMANDS.get(buf.toString())) == InternalType.BOTH || (hasCommandDotCom ? kindOf == InternalType.COMMAND : kindOf == InternalType.SHELL);
    }

    public static boolean isDriveLetterPath(String path) {
        return path.length() >= 2 && Character.isLetter(path.charAt(0)) && path.charAt(1) == ':';
    }

    private static enum InternalType {
        SHELL,
        COMMAND,
        BOTH;

    }
}

