/*
 * Decompiled with CFR 0.152.
 */
package com.starburstdata.docker.$internal.jnr.posix;

import com.starburstdata.docker.$internal.jnr.constants.platform.Sysconf;
import com.starburstdata.docker.$internal.jnr.ffi.LibraryLoader;
import com.starburstdata.docker.$internal.jnr.ffi.Pointer;
import com.starburstdata.docker.$internal.jnr.ffi.mapper.FromNativeContext;
import com.starburstdata.docker.$internal.jnr.posix.BaseNativePOSIX;
import com.starburstdata.docker.$internal.jnr.posix.FileStat;
import com.starburstdata.docker.$internal.jnr.posix.LibCProvider;
import com.starburstdata.docker.$internal.jnr.posix.MacOSFileStat;
import com.starburstdata.docker.$internal.jnr.posix.MacOSMsgHdr;
import com.starburstdata.docker.$internal.jnr.posix.MacOSPasswd;
import com.starburstdata.docker.$internal.jnr.posix.MacOSSocketMacros;
import com.starburstdata.docker.$internal.jnr.posix.MsgHdr;
import com.starburstdata.docker.$internal.jnr.posix.NSGetEnviron;
import com.starburstdata.docker.$internal.jnr.posix.NativeTimes;
import com.starburstdata.docker.$internal.jnr.posix.POSIXHandler;
import com.starburstdata.docker.$internal.jnr.posix.SocketMacros;
import com.starburstdata.docker.$internal.jnr.posix.Times;

final class MacOSPOSIX
extends BaseNativePOSIX {
    private final NSGetEnviron environ;
    public static final BaseNativePOSIX.PointerConverter PASSWD = new BaseNativePOSIX.PointerConverter(){

        public Object fromNative(Object arg, FromNativeContext ctx) {
            return arg != null ? new MacOSPasswd((Pointer)arg) : null;
        }
    };

    MacOSPOSIX(LibCProvider libcProvider, POSIXHandler handler) {
        super(libcProvider, handler);
        LibraryLoader<NSGetEnviron> loader = LibraryLoader.create(NSGetEnviron.class);
        loader.library("libSystem.B.dylib");
        this.environ = loader.load();
    }

    @Override
    public FileStat allocateStat() {
        return new MacOSFileStat(this);
    }

    @Override
    public MsgHdr allocateMsgHdr() {
        return new MacOSMsgHdr(this);
    }

    @Override
    public SocketMacros socketMacros() {
        return MacOSSocketMacros.INSTANCE;
    }

    @Override
    public long sysconf(Sysconf name) {
        return this.libc().sysconf(name);
    }

    @Override
    public Times times() {
        return NativeTimes.times(this);
    }

    @Override
    public Pointer environ() {
        return this.environ._NSGetEnviron().getPointer(0L);
    }
}

