/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages;

import com.spotify.docker.client.messages.AutoValue_HostConfig;
import com.spotify.docker.client.messages.AutoValue_HostConfig_Bind;
import com.spotify.docker.client.messages.AutoValue_HostConfig_Bind_BuilderFrom;
import com.spotify.docker.client.messages.AutoValue_HostConfig_Bind_BuilderTo;
import com.spotify.docker.client.messages.AutoValue_HostConfig_BlkioDeviceRate;
import com.spotify.docker.client.messages.AutoValue_HostConfig_BlkioWeightDevice;
import com.spotify.docker.client.messages.AutoValue_HostConfig_LxcConfParameter;
import com.spotify.docker.client.messages.AutoValue_HostConfig_RestartPolicy;
import com.spotify.docker.client.messages.AutoValue_HostConfig_Ulimit;
import com.spotify.docker.client.messages.Device;
import com.spotify.docker.client.messages.LogConfig;
import com.spotify.docker.client.messages.PortBinding;
import com.spotify.docker.client.messages.Volume;
import com.starburstdata.docker.;
import com.starburstdata.docker.$internal.com.google.common.base.Joiner;
import com.starburstdata.docker.$internal.com.google.common.base.Preconditions;
import com.starburstdata.docker.$internal.com.google.common.base.Strings;
import com.starburstdata.docker.$internal.com.google.common.collect.ImmutableList;
import com.starburstdata.docker.$internal.com.google.common.collect.ImmutableMap;
import com.starburstdata.docker.$internal.com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@.JsonAutoDetect(fieldVisibility=.JsonAutoDetect.Visibility.ANY, getterVisibility=.JsonAutoDetect.Visibility.NONE, setterVisibility=.JsonAutoDetect.Visibility.NONE)
public abstract class HostConfig {
    @.Nullable
    @.JsonProperty(value="Binds")
    public abstract ImmutableList<String> binds();

    @.Nullable
    @.JsonProperty(value="BlkioWeight")
    public abstract Integer blkioWeight();

    @.Nullable
    @.JsonProperty(value="BlkioWeightDevice")
    public abstract ImmutableList<BlkioWeightDevice> blkioWeightDevice();

    @.Nullable
    @.JsonProperty(value="BlkioDeviceReadBps")
    public abstract ImmutableList<BlkioDeviceRate> blkioDeviceReadBps();

    @.Nullable
    @.JsonProperty(value="BlkioDeviceWriteBps")
    public abstract ImmutableList<BlkioDeviceRate> blkioDeviceWriteBps();

    @.Nullable
    @.JsonProperty(value="BlkioDeviceReadIOps")
    public abstract ImmutableList<BlkioDeviceRate> blkioDeviceReadIOps();

    @.Nullable
    @.JsonProperty(value="BlkioDeviceWriteIOps")
    public abstract ImmutableList<BlkioDeviceRate> blkioDeviceWriteIOps();

    @.Nullable
    @.JsonProperty(value="ContainerIDFile")
    public abstract String containerIdFile();

    @.Nullable
    @.JsonProperty(value="LxcConf")
    public abstract ImmutableList<LxcConfParameter> lxcConf();

    @.Nullable
    @.JsonProperty(value="Privileged")
    public abstract Boolean privileged();

    @.Nullable
    @.JsonProperty(value="PortBindings")
    public abstract ImmutableMap<String, List<PortBinding>> portBindings();

    @.Nullable
    @.JsonProperty(value="Links")
    public abstract ImmutableList<String> links();

    @.Nullable
    @.JsonProperty(value="PublishAllPorts")
    public abstract Boolean publishAllPorts();

    @.Nullable
    @.JsonProperty(value="Dns")
    public abstract ImmutableList<String> dns();

    @.Nullable
    @.JsonProperty(value="DnsOptions")
    public abstract ImmutableList<String> dnsOptions();

    @.Nullable
    @.JsonProperty(value="DnsSearch")
    public abstract ImmutableList<String> dnsSearch();

    @.Nullable
    @.JsonProperty(value="ExtraHosts")
    public abstract ImmutableList<String> extraHosts();

    @.Nullable
    @.JsonProperty(value="VolumesFrom")
    public abstract ImmutableList<String> volumesFrom();

    @.Nullable
    @.JsonProperty(value="CapAdd")
    public abstract ImmutableList<String> capAdd();

    @.Nullable
    @.JsonProperty(value="CapDrop")
    public abstract ImmutableList<String> capDrop();

    @.Nullable
    @.JsonProperty(value="NetworkMode")
    public abstract String networkMode();

    @.Nullable
    @.JsonProperty(value="SecurityOpt")
    public abstract ImmutableList<String> securityOpt();

    @.Nullable
    @.JsonProperty(value="Devices")
    public abstract ImmutableList<Device> devices();

    @.Nullable
    @.JsonProperty(value="Memory")
    public abstract Long memory();

    @.Nullable
    @.JsonProperty(value="MemorySwap")
    public abstract Long memorySwap();

    @.Nullable
    @.JsonProperty(value="MemorySwappiness")
    public abstract Integer memorySwappiness();

    @.Nullable
    @.JsonProperty(value="MemoryReservation")
    public abstract Long memoryReservation();

    @.Nullable
    @.JsonProperty(value="NanoCpus")
    public abstract Long nanoCpus();

    @.Nullable
    @.JsonProperty(value="CpuPeriod")
    public abstract Long cpuPeriod();

    @.Nullable
    @.JsonProperty(value="CpuShares")
    public abstract Long cpuShares();

    @.Nullable
    @.JsonProperty(value="CpusetCpus")
    public abstract String cpusetCpus();

    @.Nullable
    @.JsonProperty(value="CpusetMems")
    public abstract String cpusetMems();

    @.Nullable
    @.JsonProperty(value="CpuQuota")
    public abstract Long cpuQuota();

    @.Nullable
    @.JsonProperty(value="CgroupParent")
    public abstract String cgroupParent();

    @.Nullable
    @.JsonProperty(value="RestartPolicy")
    public abstract RestartPolicy restartPolicy();

    @.Nullable
    @.JsonProperty(value="LogConfig")
    public abstract LogConfig logConfig();

    @.Nullable
    @.JsonProperty(value="IpcMode")
    public abstract String ipcMode();

    @.Nullable
    @.JsonProperty(value="Ulimits")
    public abstract ImmutableList<Ulimit> ulimits();

    @.Nullable
    @.JsonProperty(value="PidMode")
    public abstract String pidMode();

    @.Nullable
    @.JsonProperty(value="ShmSize")
    public abstract Long shmSize();

    @.Nullable
    @.JsonProperty(value="OomKillDisable")
    public abstract Boolean oomKillDisable();

    @.Nullable
    @.JsonProperty(value="OomScoreAdj")
    public abstract Integer oomScoreAdj();

    @.Nullable
    @.JsonProperty(value="AutoRemove")
    public abstract Boolean autoRemove();

    @.Nullable
    @.JsonProperty(value="PidsLimit")
    public abstract Integer pidsLimit();

    @.Nullable
    @.JsonProperty(value="Tmpfs")
    public abstract ImmutableMap<String, String> tmpfs();

    @.Nullable
    @.JsonProperty(value="ReadonlyRootfs")
    public abstract Boolean readonlyRootfs();

    @.Nullable
    @.JsonProperty(value="StorageOpt")
    public abstract ImmutableMap<String, String> storageOpt();

    @.JsonCreator
    static HostConfig create(@.JsonProperty(value="Binds") List<String> binds, @.JsonProperty(value="BlkioWeight") Integer blkioWeight, @.JsonProperty(value="BlkioWeightDevice") List<BlkioWeightDevice> blkioWeightDevice, @.JsonProperty(value="BlkioDeviceReadBps") List<BlkioDeviceRate> blkioDeviceReadBps, @.JsonProperty(value="BlkioDeviceWriteBps") List<BlkioDeviceRate> blkioDeviceWriteBps, @.JsonProperty(value="BlkioDeviceReadIOps") List<BlkioDeviceRate> blkioDeviceReadIOps, @.JsonProperty(value="BlkioDeviceWriteIOps") List<BlkioDeviceRate> blkioDeviceWriteIOps, @.JsonProperty(value="ContainerIDFile") String containerIdFile, @.JsonProperty(value="LxcConf") List<LxcConfParameter> lxcConf, @.JsonProperty(value="Privileged") Boolean privileged, @.JsonProperty(value="PortBindings") Map<String, List<PortBinding>> portBindings, @.JsonProperty(value="Links") List<String> links, @.JsonProperty(value="PublishAllPorts") Boolean publishAllPorts, @.JsonProperty(value="Dns") List<String> dns, @.JsonProperty(value="DnsOptions") List<String> dnsOptions, @.JsonProperty(value="DnsSearch") List<String> dnsSearch, @.JsonProperty(value="ExtraHosts") List<String> extraHosts, @.JsonProperty(value="VolumesFrom") List<String> volumesFrom, @.JsonProperty(value="CapAdd") List<String> capAdd, @.JsonProperty(value="CapDrop") List<String> capDrop, @.JsonProperty(value="NetworkMode") String networkMode, @.JsonProperty(value="SecurityOpt") List<String> securityOpt, @.JsonProperty(value="Devices") List<Device> devices, @.JsonProperty(value="Memory") Long memory, @.JsonProperty(value="MemorySwap") Long memorySwap, @.JsonProperty(value="MemorySwappiness") Integer memorySwappiness, @.JsonProperty(value="MemoryReservation") Long memoryReservation, @.JsonProperty(value="NanoCpus") Long nanoCpus, @.JsonProperty(value="CpuPeriod") Long cpuPeriod, @.JsonProperty(value="CpuShares") Long cpuShares, @.JsonProperty(value="CpusetCpus") String cpusetCpus, @.JsonProperty(value="CpusetMems") String cpusetMems, @.JsonProperty(value="CpuQuota") Long cpuQuota, @.JsonProperty(value="CgroupParent") String cgroupParent, @.JsonProperty(value="RestartPolicy") RestartPolicy restartPolicy, @.JsonProperty(value="LogConfig") LogConfig logConfig, @.JsonProperty(value="IpcMode") String ipcMode, @.JsonProperty(value="Ulimits") List<Ulimit> ulimits, @.JsonProperty(value="PidMode") String pidMode, @.JsonProperty(value="ShmSize") Long shmSize, @.JsonProperty(value="OomKillDisable") Boolean oomKillDisable, @.JsonProperty(value="OomScoreAdj") Integer oomScoreAdj, @.JsonProperty(value="AutoRemove") Boolean autoRemove, @.JsonProperty(value="PidsLimit") Integer pidsLimit, @.JsonProperty(value="Tmpfs") Map<String, String> tmpfs, @.JsonProperty(value="ReadonlyRootfs") Boolean readonlyRootfs, @.JsonProperty(value="StorageOpt") Map<String, String> storageOpt) {
        return HostConfig.builder().binds(binds).blkioWeight(blkioWeight).blkioWeightDevice(blkioWeightDevice).blkioDeviceReadBps(blkioDeviceReadBps).blkioDeviceWriteBps(blkioDeviceWriteBps).blkioDeviceReadIOps(blkioDeviceReadIOps).blkioDeviceWriteIOps(blkioDeviceWriteIOps).containerIdFile(containerIdFile).lxcConf(lxcConf).privileged(privileged).portBindings(portBindings).links(links).publishAllPorts(publishAllPorts).dns(dns).dnsOptions(dnsOptions).dnsSearch(dnsSearch).extraHosts(extraHosts).volumesFrom(volumesFrom).capAdd(capAdd).capDrop(capDrop).networkMode(networkMode).securityOpt(securityOpt).devices(devices).memory(memory).memorySwap(memorySwap).memorySwappiness(memorySwappiness).memoryReservation(memoryReservation).nanoCpus(nanoCpus).cpuPeriod(cpuPeriod).cpuShares(cpuShares).cpusetCpus(cpusetCpus).cpusetMems(cpusetMems).cpuQuota(cpuQuota).cgroupParent(cgroupParent).restartPolicy(restartPolicy).logConfig(logConfig).ipcMode(ipcMode).ulimits(ulimits).pidMode(pidMode).shmSize(shmSize).oomKillDisable(oomKillDisable).oomScoreAdj(oomScoreAdj).autoRemove(autoRemove).pidsLimit(pidsLimit).tmpfs(tmpfs).readonlyRootfs(readonlyRootfs).storageOpt(storageOpt).build();
    }

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new AutoValue_HostConfig.Builder();
    }

    private static void validateExtraHosts(List<String> extraHosts) {
        if (extraHosts != null) {
            for (String extraHost : extraHosts) {
                Preconditions.checkArgument(extraHost.contains(":"), "extra host arg '%s' must contain a ':'", (Object)extraHost);
            }
        }
    }

    public static abstract class BlkioDeviceRate {
        @.JsonProperty(value="Path")
        public abstract String path();

        @.JsonProperty(value="Rate")
        public abstract Integer rate();

        @.JsonCreator
        static BlkioDeviceRate create(@.JsonProperty(value="Path") String path, @.JsonProperty(value="Rate") Integer rate) {
            return BlkioDeviceRate.builder().path(path).rate(rate).build();
        }

        public static Builder builder() {
            return new AutoValue_HostConfig_BlkioDeviceRate.Builder();
        }

        public static abstract class Builder {
            public abstract Builder path(String var1);

            public abstract Builder rate(Integer var1);

            public abstract BlkioDeviceRate build();
        }
    }

    public static abstract class BlkioWeightDevice {
        @.JsonProperty(value="Path")
        public abstract String path();

        @.JsonProperty(value="Weight")
        public abstract Integer weight();

        public static Builder builder() {
            return new AutoValue_HostConfig_BlkioWeightDevice.Builder();
        }

        @.JsonCreator
        static BlkioWeightDevice create(@.JsonProperty(value="Path") String path, @.JsonProperty(value="Weight") Integer weight) {
            return BlkioWeightDevice.builder().path(path).weight(weight).build();
        }

        public static abstract class Builder {
            public abstract Builder path(String var1);

            public abstract Builder weight(Integer var1);

            public abstract BlkioWeightDevice build();
        }
    }

    public static abstract class Ulimit {
        @.JsonProperty(value="Name")
        public abstract String name();

        @.JsonProperty(value="Soft")
        public abstract Long soft();

        @.JsonProperty(value="Hard")
        public abstract Long hard();

        public static Builder builder() {
            return new AutoValue_HostConfig_Ulimit.Builder();
        }

        @.JsonCreator
        public static Ulimit create(@.JsonProperty(value="Name") String name, @.JsonProperty(value="Soft") Long soft, @.JsonProperty(value="Hard") Long hard) {
            return Ulimit.builder().name(name).soft(soft).hard(hard).build();
        }

        public static abstract class Builder {
            public abstract Builder name(String var1);

            public abstract Builder soft(Long var1);

            public abstract Builder hard(Long var1);

            public abstract Ulimit build();
        }
    }

    public static abstract class Bind {
        public abstract String to();

        public static BuilderTo to(String to) {
            return BuilderTo.create(to);
        }

        public abstract String from();

        public static BuilderFrom from(String from) {
            return BuilderFrom.create(from);
        }

        public static BuilderFrom from(Volume volumeFrom) {
            return BuilderFrom.create(volumeFrom);
        }

        public abstract Boolean readOnly();

        @.Nullable
        public abstract Boolean noCopy();

        @.Nullable
        public abstract Boolean selinuxLabeling();

        public static Builder builder() {
            return new AutoValue_HostConfig_Bind.Builder().readOnly(false);
        }

        @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
        public String toString() {
            String optionsValue;
            if (Strings.isNullOrEmpty(this.to())) {
                return "";
            }
            if (Strings.isNullOrEmpty(this.from())) {
                return this.to();
            }
            String bind = this.from() + ":" + this.to();
            ArrayList<String> options = new ArrayList<String>();
            if (this.readOnly().booleanValue()) {
                options.add("ro");
            }
            if (this.noCopy() != null && this.noCopy().booleanValue()) {
                options.add("nocopy");
            }
            if (this.selinuxLabeling() != null) {
                if (Boolean.TRUE.equals(this.selinuxLabeling())) {
                    options.add("z");
                } else {
                    options.add("Z");
                }
            }
            return (optionsValue = Joiner.on(',').join(options)).isEmpty() ? bind : bind + ":" + optionsValue;
        }

        public static abstract class Builder {
            public abstract Builder to(String var1);

            public abstract Builder from(String var1);

            public Builder from(Volume volumeFrom) {
                this.from(Preconditions.checkNotNull(volumeFrom.name(), "Volume name"));
                return this;
            }

            public abstract Builder readOnly(Boolean var1);

            public abstract Builder noCopy(Boolean var1);

            public abstract Builder selinuxLabeling(Boolean var1);

            public abstract Bind build();
        }

        public static abstract class BuilderFrom {
            public abstract String from();

            public static BuilderFrom create(String from) {
                return new AutoValue_HostConfig_Bind_BuilderFrom(from);
            }

            public static BuilderFrom create(Volume volumeFrom) {
                return new AutoValue_HostConfig_Bind_BuilderFrom(Preconditions.checkNotNull(volumeFrom.name(), "Volume name"));
            }

            public Builder to(String to) {
                return Bind.builder().to(to).from(this.from());
            }
        }

        public static abstract class BuilderTo {
            public abstract String to();

            public static BuilderTo create(String to) {
                return new AutoValue_HostConfig_Bind_BuilderTo(to);
            }

            public Builder from(String from) {
                return Bind.builder().to(this.to()).from(from);
            }

            public Builder from(Volume volumeFrom) {
                return Bind.builder().to(this.to()).from(volumeFrom);
            }
        }
    }

    public static abstract class Builder {
        public abstract Builder binds(List<String> var1);

        public abstract Builder binds(String ... var1);

        public Builder binds(Bind ... binds) {
            if (binds == null || binds.length == 0) {
                return this;
            }
            return this.binds(Builder.toStringList(binds));
        }

        abstract ImmutableList<String> binds();

        private static List<String> toStringList(Bind[] binds) {
            ArrayList<String> bindStrings = Lists.newArrayList();
            for (Bind bind : binds) {
                bindStrings.add(bind.toString());
            }
            return bindStrings;
        }

        public Builder appendBinds(Iterable<String> newBinds) {
            ArrayList<String> list = new ArrayList<String>();
            if (this.binds() != null) {
                list.addAll(this.binds());
            }
            list.addAll(Lists.newArrayList(newBinds));
            this.binds(Builder.copyWithoutDuplicates(list));
            return this;
        }

        public Builder appendBinds(Bind ... binds) {
            this.appendBinds(Builder.toStringList(binds));
            return this;
        }

        public Builder appendBinds(String ... binds) {
            this.appendBinds(Lists.newArrayList(binds));
            return this;
        }

        private static <T> ImmutableList<T> copyWithoutDuplicates(List<T> input) {
            ArrayList<T> list = new ArrayList<T>(input.size());
            for (T element : input) {
                if (list.contains(element)) continue;
                list.add(element);
            }
            return ImmutableList.copyOf(list);
        }

        public abstract Builder blkioWeight(Integer var1);

        public abstract Builder blkioWeightDevice(List<BlkioWeightDevice> var1);

        public abstract Builder blkioDeviceReadBps(List<BlkioDeviceRate> var1);

        public abstract Builder blkioDeviceWriteBps(List<BlkioDeviceRate> var1);

        public abstract Builder blkioDeviceReadIOps(List<BlkioDeviceRate> var1);

        public abstract Builder blkioDeviceWriteIOps(List<BlkioDeviceRate> var1);

        public abstract Builder containerIdFile(String var1);

        public abstract Builder lxcConf(List<LxcConfParameter> var1);

        public abstract Builder lxcConf(LxcConfParameter ... var1);

        public abstract Builder privileged(Boolean var1);

        public abstract Builder portBindings(Map<String, List<PortBinding>> var1);

        public abstract Builder links(List<String> var1);

        public abstract Builder links(String ... var1);

        public abstract Builder publishAllPorts(Boolean var1);

        public abstract Builder dns(List<String> var1);

        public abstract Builder dns(String ... var1);

        public abstract Builder dnsOptions(List<String> var1);

        public abstract Builder dnsOptions(String ... var1);

        public abstract Builder dnsSearch(List<String> var1);

        public abstract Builder dnsSearch(String ... var1);

        public abstract Builder extraHosts(List<String> var1);

        public abstract Builder extraHosts(String ... var1);

        public abstract Builder volumesFrom(List<String> var1);

        public abstract Builder volumesFrom(String ... var1);

        public abstract Builder capAdd(List<String> var1);

        public abstract Builder capAdd(String ... var1);

        public abstract Builder capDrop(List<String> var1);

        public abstract Builder capDrop(String ... var1);

        public abstract Builder networkMode(String var1);

        public abstract Builder securityOpt(List<String> var1);

        public abstract Builder securityOpt(String ... var1);

        public abstract Builder devices(List<Device> var1);

        public abstract Builder devices(Device ... var1);

        public abstract Builder memory(Long var1);

        public abstract Builder memorySwap(Long var1);

        public abstract Builder memorySwappiness(Integer var1);

        public abstract Builder memoryReservation(Long var1);

        public abstract Builder nanoCpus(Long var1);

        public abstract Builder cpuPeriod(Long var1);

        public abstract Builder cpuShares(Long var1);

        public abstract Builder cpusetCpus(String var1);

        public abstract Builder cpusetMems(String var1);

        public abstract Builder cpuQuota(Long var1);

        public abstract Builder cgroupParent(String var1);

        public abstract Builder restartPolicy(RestartPolicy var1);

        public abstract Builder logConfig(LogConfig var1);

        public abstract Builder ipcMode(String var1);

        public abstract Builder ulimits(List<Ulimit> var1);

        public abstract Builder pidMode(String var1);

        public Builder containerPidMode(String container) {
            this.pidMode("container:" + container);
            return this;
        }

        public Builder hostPidMode() {
            this.pidMode("host");
            return this;
        }

        public abstract Builder shmSize(Long var1);

        public abstract Builder oomKillDisable(Boolean var1);

        public abstract Builder oomScoreAdj(Integer var1);

        public abstract Builder autoRemove(Boolean var1);

        public abstract Builder pidsLimit(Integer var1);

        public abstract Builder tmpfs(Map<String, String> var1);

        public abstract Builder readonlyRootfs(Boolean var1);

        public abstract Builder storageOpt(Map<String, String> var1);

        abstract HostConfig autoBuild();

        public HostConfig build() {
            HostConfig hostConfig = this.autoBuild();
            HostConfig.validateExtraHosts(hostConfig.extraHosts());
            return hostConfig;
        }
    }

    public static abstract class RestartPolicy {
        @.JsonProperty(value="Name")
        public abstract String name();

        @.Nullable
        @.JsonProperty(value="MaximumRetryCount")
        public abstract Integer maxRetryCount();

        public static RestartPolicy always() {
            return new AutoValue_HostConfig_RestartPolicy("always", null);
        }

        public static RestartPolicy unlessStopped() {
            return new AutoValue_HostConfig_RestartPolicy("unless-stopped", null);
        }

        public static RestartPolicy onFailure(Integer maxRetryCount) {
            return new AutoValue_HostConfig_RestartPolicy("on-failure", maxRetryCount);
        }

        @.JsonCreator
        static RestartPolicy create(@.JsonProperty(value="Name") String name, @.JsonProperty(value="MaximumRetryCount") Integer maxRetryCount) {
            return new AutoValue_HostConfig_RestartPolicy(name, maxRetryCount);
        }
    }

    public static abstract class LxcConfParameter {
        @.JsonProperty(value="Key")
        public abstract String key();

        @.JsonProperty(value="Value")
        public abstract String value();

        @.JsonCreator
        static LxcConfParameter create(@.JsonProperty(value="Key") String key, @.JsonProperty(value="Value") String value) {
            return new AutoValue_HostConfig_LxcConfParameter(key, value);
        }
    }
}

