/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client;

import com.starburstdata.docker.;
import com.starburstdata.docker.$internal.jnr.unixsocket.UnixSocket;
import com.starburstdata.docker.$internal.jnr.unixsocket.UnixSocketAddress;
import com.starburstdata.docker.$internal.jnr.unixsocket.UnixSocketChannel;
import com.starburstdata.docker.$internal.org.apache.http.conn.ConnectTimeoutException;
import com.starburstdata.docker.$internal.org.apache.http.conn.socket.ConnectionSocketFactory;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URI;

@.Contract(threading=.ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class UnixConnectionSocketFactory
implements ConnectionSocketFactory {
    private File socketFile;

    public UnixConnectionSocketFactory(URI socketUri) {
        String filename = socketUri.toString().replaceAll("^unix:///", "unix://localhost/").replaceAll("^unix://localhost", "");
        this.socketFile = new File(filename);
    }

    public static URI sanitizeUri(URI uri) {
        if (uri.getScheme().equals("unix")) {
            return URI.create("unix://localhost:80");
        }
        return uri;
    }

    @Override
    public UnixSocket createSocket(.HttpContext context) throws IOException {
        return UnixSocketChannel.open().socket();
    }

    @Override
    public Socket connectSocket(int connectTimeout, Socket socket, .HttpHost host, InetSocketAddress remoteAddress, InetSocketAddress localAddress, .HttpContext context) throws IOException {
        if (!(socket instanceof UnixSocket)) {
            throw new AssertionError((Object)("Unexpected socket: " + socket));
        }
        socket.setSoTimeout(connectTimeout);
        try {
            socket.getChannel().connect(new UnixSocketAddress(this.socketFile));
        }
        catch (SocketTimeoutException e) {
            throw new ConnectTimeoutException(e, null, remoteAddress.getAddress());
        }
        return socket;
    }
}

