/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client;

import com.spotify.docker.client.LogMessage;
import com.starburstdata.docker.$internal.com.google.common.io.ByteStreams;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class LogReader
implements Closeable {
    private final InputStream stream;
    public static final int HEADER_SIZE = 8;
    public static final int FRAME_SIZE_OFFSET = 4;

    public LogReader(InputStream stream) {
        this.stream = stream;
    }

    public LogMessage nextMessage() throws IOException {
        byte[] frame;
        this.stream.mark(8);
        byte[] headerBytes = new byte[8];
        int n = ByteStreams.read(this.stream, headerBytes, 0, 8);
        if (n == 0) {
            return null;
        }
        ByteBuffer header = ByteBuffer.wrap(headerBytes);
        int streamId = header.get();
        int idZ = header.getInt(0);
        if (idZ == 0 || idZ == 0x1000000 || idZ == 0x2000000) {
            header.position(4);
            int frameSize = header.getInt();
            frame = new byte[frameSize];
        } else {
            this.stream.reset();
            streamId = LogMessage.Stream.STDOUT.id();
            frame = new byte[this.stream.available()];
        }
        ByteStreams.readFully(this.stream, frame);
        return new LogMessage(streamId, ByteBuffer.wrap(frame));
    }

    @Override
    public void close() throws IOException {
        ByteStreams.copy(this.stream, ByteStreams.nullOutputStream());
    }
}

