/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client;

import com.spotify.docker.client.DockerCertificatesStore;
import com.spotify.docker.client.exceptions.DockerCertificateException;
import com.starburstdata.docker.$internal.com.google.common.base.Joiner;
import com.starburstdata.docker.$internal.com.google.common.base.Optional;
import com.starburstdata.docker.$internal.com.google.common.collect.ImmutableSet;
import com.starburstdata.docker.$internal.org.apache.http.conn.ssl.NoopHostnameVerifier;
import com.starburstdata.docker.$internal.org.apache.http.ssl.SSLContexts;
import com.starburstdata.docker.$internal.org.slf4j.Logger;
import com.starburstdata.docker.$internal.org.slf4j.LoggerFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyFactory;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;

public class DockerCertificates
implements DockerCertificatesStore {
    public static final String DEFAULT_CA_CERT_NAME = "ca.pem";
    public static final String DEFAULT_CLIENT_CERT_NAME = "cert.pem";
    public static final String DEFAULT_CLIENT_KEY_NAME = "key.pem";
    private static final char[] KEY_STORE_PASSWORD = "docker!!11!!one!".toCharArray();
    private static final Set<String> PRIVATE_KEY_ALGS = ImmutableSet.of("RSA", "EC");
    private static final Logger log = LoggerFactory.getLogger(DockerCertificates.class);
    private final SSLContext sslContext;

    public DockerCertificates(Path dockerCertPath) throws DockerCertificateException {
        this(new Builder().dockerCertPath(dockerCertPath));
    }

    private DockerCertificates(Builder builder) throws DockerCertificateException {
        if (builder.caCertPath == null || builder.clientCertPath == null || builder.clientKeyPath == null) {
            throw new DockerCertificateException("caCertPath, clientCertPath, and clientKeyPath must all be specified");
        }
        try {
            PrivateKey clientKey = this.readPrivateKey(builder.clientKeyPath);
            List<Certificate> clientCerts = this.readCertificates(builder.clientCertPath);
            KeyStore keyStore = this.newKeyStore();
            keyStore.setKeyEntry("key", clientKey, KEY_STORE_PASSWORD, clientCerts.toArray(new Certificate[clientCerts.size()]));
            List<Certificate> caCerts = this.readCertificates(builder.caCertPath);
            KeyStore trustStore = this.newKeyStore();
            for (Certificate caCert : caCerts) {
                X509Certificate crt = (X509Certificate)caCert;
                String alias = crt.getSubjectX500Principal().getName();
                trustStore.setCertificateEntry(alias, caCert);
            }
            this.sslContext = builder.sslContextFactory.newSslContext(keyStore, KEY_STORE_PASSWORD, trustStore);
        }
        catch (DockerCertificateException e) {
            throw e;
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException | InvalidKeySpecException e) {
            throw new DockerCertificateException(e);
        }
    }

    private KeyStore newKeyStore() throws CertificateException, NoSuchAlgorithmException, IOException, KeyStoreException {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(null);
        return keyStore;
    }

    private PrivateKey readPrivateKey(Path file) throws IOException, InvalidKeySpecException, DockerCertificateException {
        Throwable throwable = null;
        try (BufferedReader reader = Files.newBufferedReader(file, Charset.defaultCharset());){
            Throwable throwable2;
            PEMParser pemParser;
            block34: {
                PrivateKey privateKey;
                block35: {
                    block36: {
                        Object readObject;
                        block31: {
                            PrivateKey privateKey2;
                            block32: {
                                block33: {
                                    pemParser = new PEMParser(reader);
                                    throwable2 = null;
                                    readObject = pemParser.readObject();
                                    if (!(readObject instanceof PEMKeyPair)) break block31;
                                    PEMKeyPair clientKeyPair = (PEMKeyPair)readObject;
                                    privateKey2 = DockerCertificates.generatePrivateKey(clientKeyPair.getPrivateKeyInfo());
                                    if (pemParser == null) break block32;
                                    if (throwable2 == null) break block33;
                                    try {
                                        pemParser.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable2.addSuppressed(throwable3);
                                    }
                                    break block32;
                                }
                                pemParser.close();
                            }
                            return privateKey2;
                        }
                        if (!(readObject instanceof PrivateKeyInfo)) break block34;
                        privateKey = DockerCertificates.generatePrivateKey((PrivateKeyInfo)readObject);
                        if (pemParser == null) break block35;
                        if (throwable2 == null) break block36;
                        try {
                            pemParser.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        break block35;
                    }
                    pemParser.close();
                }
                return privateKey;
            }
            try {
                try {
                    try {
                        throw new DockerCertificateException("Can not generate private key from file: " + file.toString());
                    }
                    catch (Throwable throwable5) {
                        throwable2 = throwable5;
                        throw throwable5;
                    }
                }
                catch (Throwable throwable6) {
                    if (pemParser != null) {
                        if (throwable2 != null) {
                            try {
                                pemParser.close();
                            }
                            catch (Throwable throwable7) {
                                throwable2.addSuppressed(throwable7);
                            }
                        } else {
                            pemParser.close();
                        }
                    }
                    throw throwable6;
                }
            }
            catch (Throwable throwable8) {
                throwable = throwable8;
                throw throwable8;
            }
        }
    }

    private static PrivateKey generatePrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException, InvalidKeySpecException {
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(privateKeyInfo.getEncoded());
        return DockerCertificates.tryGeneratePrivateKey(spec, PRIVATE_KEY_ALGS);
    }

    private static PrivateKey tryGeneratePrivateKey(PKCS8EncodedKeySpec spec, Set<String> algorithms) throws InvalidKeySpecException {
        for (String algorithm : algorithms) {
            try {
                KeyFactory kf = KeyFactory.getInstance(algorithm);
                PrivateKey key = kf.generatePrivate(spec);
                log.debug("Generated private key from spec using the '{}' algorithm", (Object)algorithm);
                return key;
            }
            catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                log.debug("Tried generating private key from spec using the '{}' algorithm", (Object)algorithm, (Object)e);
            }
        }
        String error = String.format("Could not generate private key from spec. Tried using %s", Joiner.on(", ").join(algorithms));
        throw new InvalidKeySpecException(error);
    }

    private List<Certificate> readCertificates(Path file) throws CertificateException, IOException {
        try (InputStream inputStream = Files.newInputStream(file, new OpenOption[0]);){
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            ArrayList<Certificate> arrayList = new ArrayList<Certificate>(cf.generateCertificates(inputStream));
            return arrayList;
        }
    }

    @Override
    public SSLContext sslContext() {
        return this.sslContext;
    }

    @Override
    public HostnameVerifier hostnameVerifier() {
        return NoopHostnameVerifier.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private SslContextFactory sslContextFactory = new DefaultSslContextFactory();
        private Path caCertPath;
        private Path clientKeyPath;
        private Path clientCertPath;

        public Builder dockerCertPath(Path dockerCertPath) {
            this.caCertPath = dockerCertPath.resolve(DockerCertificates.DEFAULT_CA_CERT_NAME);
            this.clientKeyPath = dockerCertPath.resolve(DockerCertificates.DEFAULT_CLIENT_KEY_NAME);
            this.clientCertPath = dockerCertPath.resolve(DockerCertificates.DEFAULT_CLIENT_CERT_NAME);
            return this;
        }

        public Builder caCertPath(Path caCertPath) {
            this.caCertPath = caCertPath;
            return this;
        }

        public Builder clientKeyPath(Path clientKeyPath) {
            this.clientKeyPath = clientKeyPath;
            return this;
        }

        public Builder clientCertPath(Path clientCertPath) {
            this.clientCertPath = clientCertPath;
            return this;
        }

        public Builder sslFactory(SslContextFactory sslContextFactory) {
            this.sslContextFactory = sslContextFactory;
            return this;
        }

        public Optional<DockerCertificatesStore> build() throws DockerCertificateException {
            if (this.caCertPath == null || this.clientKeyPath == null || this.clientCertPath == null) {
                log.debug("caCertPath, clientKeyPath or clientCertPath not specified, not using SSL");
                return Optional.absent();
            }
            if (Files.exists(this.caCertPath, new LinkOption[0]) && Files.exists(this.clientKeyPath, new LinkOption[0]) && Files.exists(this.clientCertPath, new LinkOption[0])) {
                return Optional.of(new DockerCertificates(this));
            }
            log.debug("{}, {} or {} does not exist, not using SSL", this.caCertPath, this.clientKeyPath, this.clientCertPath);
            return Optional.absent();
        }
    }

    private static class DefaultSslContextFactory
    implements SslContextFactory {
        private DefaultSslContextFactory() {
        }

        @Override
        public SSLContext newSslContext(KeyStore keyStore, char[] keyPassword, KeyStore trustStore) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException {
            return SSLContexts.custom().loadTrustMaterial(trustStore, null).loadKeyMaterial(keyStore, keyPassword).build();
        }
    }

    public static interface SslContextFactory {
        public SSLContext newSslContext(KeyStore var1, char[] var2, KeyStore var3) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException;
    }
}

