/*
 * Decompiled with CFR 0.152.
 */
package com.srcclr.sdk;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.srcclr.sdk.BaseBuilder;
import com.srcclr.sdk.BaseModel;
import com.srcclr.sdk.CoordinateType;
import com.srcclr.sdk.LanguageType;
import com.srcclr.sdk.LibraryVersion;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@JsonDeserialize(builder=Builder.class)
@Immutable
public class Library
extends BaseModel {
    private final String name;
    private final String description;
    private final String author;
    private final String authorUrl;
    private final LanguageType language;
    private final CoordinateType coordinateType;
    private final String coordinate1;
    private final String coordinate2;
    private final String bugTrackerUrl;
    private final String codeRepoType;
    private final String codeRepoUrl;
    private final String latestRelease;
    private final Date latestReleaseDate;
    private final String recommendedVersion;
    private final Collection<LibraryVersion> versions;

    private Library(Builder builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.author = builder.author;
        this.authorUrl = builder.authorUrl;
        this.language = builder.language;
        this.coordinateType = builder.coordinateType;
        this.coordinate1 = builder.coordinate1;
        this.coordinate2 = builder.coordinate2;
        this.bugTrackerUrl = builder.bugTrackerUrl;
        this.codeRepoType = builder.codeRepoType;
        this.codeRepoUrl = builder.codeRepoUrl;
        this.latestRelease = builder.latestRelease;
        this.latestReleaseDate = builder.latestReleaseDate;
        this.recommendedVersion = builder.recommendedVersion;
        this.versions = Collections.unmodifiableCollection(builder.versions);
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getAuthorUrl() {
        return this.authorUrl;
    }

    @Nonnull
    public LanguageType getLanguage() {
        return this.language;
    }

    public CoordinateType getCoordinateType() {
        return this.coordinateType;
    }

    public String getCoordinate1() {
        return this.coordinate1;
    }

    public String getCoordinate2() {
        return this.coordinate2;
    }

    public String getBugTrackerUrl() {
        return this.bugTrackerUrl;
    }

    public String getCodeRepoType() {
        return this.codeRepoType;
    }

    public String getCodeRepoUrl() {
        return this.codeRepoUrl;
    }

    public String getLatestRelease() {
        return this.latestRelease;
    }

    public Date getLatestReleaseDate() {
        return this.latestReleaseDate;
    }

    @Nonnull
    public Collection<LibraryVersion> getVersions() {
        return this.versions;
    }

    @Nullable
    public String getRecommendedVersion() {
        return this.recommendedVersion;
    }

    public static class Builder
    extends BaseBuilder<Builder, Library> {
        private String name;
        private String description;
        private String author;
        private String authorUrl;
        private LanguageType language;
        private CoordinateType coordinateType;
        private String coordinate1;
        private String coordinate2;
        private String bugTrackerUrl;
        private String codeRepoType;
        private String codeRepoUrl;
        private String latestRelease;
        private Date latestReleaseDate;
        private String recommendedVersion;
        private Collection<LibraryVersion> versions = new LinkedList<LibraryVersion>();

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder withAuthor(String author) {
            this.author = author;
            return this;
        }

        public Builder withAuthorUrl(String authorUrl) {
            this.authorUrl = authorUrl;
            return this;
        }

        public Builder withLanguage(LanguageType language) {
            this.language = language;
            return this;
        }

        public Builder withCoordinateType(CoordinateType coordinateType) {
            this.coordinateType = coordinateType;
            return this;
        }

        public Builder withCoordinate1(String coordinate1) {
            this.coordinate1 = coordinate1;
            return this;
        }

        public Builder withCoordinate2(String coordinate2) {
            this.coordinate2 = coordinate2;
            return this;
        }

        public Builder withBugTrackerUrl(String bugTrackerUrl) {
            this.bugTrackerUrl = bugTrackerUrl;
            return this;
        }

        public Builder withCodeRepoType(String codeRepoType) {
            this.codeRepoType = codeRepoType;
            return this;
        }

        public Builder withCodeRepoUrl(String codeRepoUrl) {
            this.codeRepoUrl = codeRepoUrl;
            return this;
        }

        public Builder withLatestRelease(String latestRelease) {
            this.latestRelease = latestRelease;
            return this;
        }

        public Builder withLatestReleaseDate(Date latestReleaseDate) {
            this.latestReleaseDate = latestReleaseDate;
            return this;
        }

        public Builder withRecommendedVersion(String recommendedVersion) {
            this.recommendedVersion = recommendedVersion;
            return this;
        }

        public Builder withVersions(Collection<LibraryVersion> versions) {
            this.versions = versions;
            return this;
        }

        @Override
        public Library build() {
            return new Library(this);
        }
    }
}

