/*
 * Decompiled with CFR 0.152.
 */
package com.srcclr.sdk;

import com.srcclr.sdk.DepGraph;
import com.srcclr.sdk.Edge;
import com.srcclr.sdk.LibraryEvidence;
import com.srcclr.sdk.LibraryGraph;
import com.srcclr.sdk.LibraryJGraphT;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.graph.DirectedAcyclicGraph;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u00192\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u00d6\u0003J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00030\u0019H\u0016J\t\u0010\u001f\u001a\u00020\u0017H\u00d6\u0001J\u0014\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\bH\u0016J\b\u0010!\u001a\u00020\"H\u0017J\t\u0010#\u001a\u00020$H\u00d6\u0001R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006%"}, d2={"Lcom/srcclr/sdk/DepGraphImpl;", "Lcom/srcclr/sdk/DepGraph;", "root", "Lcom/srcclr/sdk/LibraryEvidence;", "(Lcom/srcclr/sdk/LibraryEvidence;)V", "directs", "", "graph", "Lorg/jgrapht/Graph;", "Lcom/srcclr/sdk/Edge;", "getGraph", "()Lorg/jgrapht/Graph;", "getRoot", "()Lcom/srcclr/sdk/LibraryEvidence;", "addDependency", "", "from", "to", "addLibrary", "library", "component1", "copy", "countLibraries", "", "dependenciesOf", "", "equals", "", "other", "", "getDirects", "hashCode", "toGraph", "toLibraryGraph", "Lcom/srcclr/sdk/LibraryGraph;", "toString", "", "srcclr-sdk-core"})
public final class DepGraphImpl
implements DepGraph {
    @NotNull
    private final LibraryEvidence root;
    @NotNull
    private final Graph<LibraryEvidence, Edge> graph;
    @NotNull
    private final List<LibraryEvidence> directs;

    public DepGraphImpl(@NotNull LibraryEvidence root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this.root = root;
        this.graph = (Graph)new DirectedAcyclicGraph(Edge.class);
        this.directs = new ArrayList();
    }

    @NotNull
    public final LibraryEvidence getRoot() {
        return this.root;
    }

    @NotNull
    public final Graph<LibraryEvidence, Edge> getGraph() {
        return this.graph;
    }

    @Override
    public void addLibrary(@NotNull LibraryEvidence library) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        if (Intrinsics.areEqual((Object)library, (Object)this.root)) {
            return;
        }
        this.graph.addVertex((Object)library);
    }

    @Override
    public void addDependency(@NotNull LibraryEvidence from, @NotNull LibraryEvidence to) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        this.addLibrary(to);
        if (Intrinsics.areEqual((Object)from, (Object)this.root)) {
            if (!this.directs.contains(to) && !Intrinsics.areEqual((Object)to, (Object)this.root)) {
                this.directs.add(to);
            }
            return;
        }
        this.addLibrary(from);
        try {
            this.graph.addEdge((Object)from, (Object)to);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Override
    @Deprecated(message="only here for interop with legacy code")
    @NotNull
    public LibraryGraph toLibraryGraph() {
        LibraryJGraphT result = new LibraryJGraphT(this.root.toLibraryGraphVertex());
        Iterable $this$forEach$iv = this.getDirects();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LibraryEvidence it = (LibraryEvidence)element$iv;
            boolean bl = false;
            result.dependsOn(this.root.toLibraryGraphVertex(), it.toLibraryGraphVertex());
        }
        Set set = this.graph.edgeSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"graph.edgeSet()");
        $this$forEach$iv = set;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Edge e = (Edge)((Object)element$iv);
            boolean bl = false;
            result.dependsOn(((LibraryEvidence)this.graph.getEdgeSource((Object)e)).toLibraryGraphVertex(), ((LibraryEvidence)this.graph.getEdgeTarget((Object)e)).toLibraryGraphVertex());
        }
        return result.toLibraryGraph();
    }

    @Override
    @NotNull
    public Graph<LibraryEvidence, Edge> toGraph() {
        DirectedAcyclicGraph r = new DirectedAcyclicGraph(Edge.class);
        Graphs.addGraph((Graph)((Graph)r), this.graph);
        r.addVertex((Object)this.root);
        Iterable $this$forEach$iv = this.getDirects();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LibraryEvidence it = (LibraryEvidence)element$iv;
            boolean bl = false;
            r.addEdge((Object)this.root, (Object)it);
        }
        return (Graph)r;
    }

    @Override
    @NotNull
    public List<LibraryEvidence> getDirects() {
        return this.directs;
    }

    @Override
    public int countLibraries() {
        Set set = this.graph.vertexSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"graph.vertexSet()");
        return ((Collection)set).size() + 1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<LibraryEvidence> dependenciesOf(@NotNull LibraryEvidence library) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        if (Intrinsics.areEqual((Object)library, (Object)this.root)) {
            return this.getDirects();
        }
        Set set = this.graph.outgoingEdgesOf((Object)library);
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"graph.outgoingEdgesOf(library)");
        Iterable $this$map$iv = set;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Edge edge = (Edge)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((LibraryEvidence)this.graph.getEdgeTarget((Object)it));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final LibraryEvidence component1() {
        return this.root;
    }

    @NotNull
    public final DepGraphImpl copy(@NotNull LibraryEvidence root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        return new DepGraphImpl(root);
    }

    public static /* synthetic */ DepGraphImpl copy$default(DepGraphImpl depGraphImpl, LibraryEvidence libraryEvidence, int n, Object object) {
        if ((n & 1) != 0) {
            libraryEvidence = depGraphImpl.root;
        }
        return depGraphImpl.copy(libraryEvidence);
    }

    @NotNull
    public String toString() {
        return "DepGraphImpl(root=" + this.root + ')';
    }

    public int hashCode() {
        return this.root.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DepGraphImpl)) {
            return false;
        }
        DepGraphImpl depGraphImpl = (DepGraphImpl)other;
        return Intrinsics.areEqual((Object)this.root, (Object)depGraphImpl.root);
    }
}

