/*
 * Decompiled with CFR 0.152.
 */
package com.srcclr.sdk;

import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.srcclr.sdk.BuildType;
import com.srcclr.sdk.CoordinateType;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@JsonDeserialize(builder=Builder.class)
public class Coords {
    public static final String UNDEFINED_VALUE = "<undefined>";
    @NotNull
    private final CoordinateType coordinateType;
    @NotNull
    @Size(min=1)
    private final String coordinate1;
    private final String coordinate2;
    @NotNull
    @Size(min=1)
    private final String version;
    private final String scope;
    private final String platform;
    private final String commitHash;

    private Coords(Builder builder) {
        this.coordinateType = builder.coordinateType;
        this.coordinate1 = builder.coordinate1;
        this.coordinate2 = builder.coordinate2;
        this.version = builder.version;
        this.scope = builder.scope;
        this.platform = builder.platform;
        this.commitHash = builder.commitHash;
    }

    public String toRawString() {
        String str;
        String string = str = this.coordinate2 != null ? String.format("%s:%s:%s", this.coordinate1, this.coordinate2, this.version) : String.format("%s:%s", this.coordinate1, this.version);
        if (this.scope != null && !this.scope.isEmpty()) {
            str = str + ":" + this.scope;
        }
        if (this.commitHash != null) {
            str = str + ":" + this.commitHash;
        }
        return str;
    }

    public String toString() {
        String str;
        String string = str = this.coordinate2 != null ? String.format("%s/%s:%s:%s", new Object[]{this.coordinateType, this.coordinate1, this.coordinate2, this.version}) : String.format("%s/%s:%s", new Object[]{this.coordinateType, this.coordinate1, this.version});
        if (this.scope != null && !this.scope.isEmpty()) {
            str = str + ":" + this.scope;
        }
        if (this.commitHash != null) {
            str = str + ":" + this.commitHash;
        }
        return str;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Coords)) {
            return false;
        }
        Coords that = (Coords)o;
        return Objects.equals((Object)this.getCoordinateType(), (Object)that.getCoordinateType()) && Objects.equals(this.getCoordinate1(), that.getCoordinate1()) && Objects.equals(this.getCoordinate2(), that.getCoordinate2()) && Objects.equals(this.getVersion(), that.getVersion()) && Objects.equals(this.getScope(), that.getScope()) && Objects.equals(this.getPlatform(), that.getPlatform()) && Objects.equals(this.getCommitHash(), that.getCommitHash());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getCoordinateType(), this.getCoordinate1(), this.getCoordinate2(), this.getVersion(), this.getScope(), this.getPlatform(), this.getCommitHash()});
    }

    public CoordinateType getCoordinateType() {
        return this.coordinateType;
    }

    public String getCoordinate1() {
        return this.coordinate1;
    }

    public String getCoordinate2() {
        return this.coordinate2;
    }

    public String getVersion() {
        return this.version;
    }

    public String getScope() {
        return this.scope;
    }

    public String getPlatform() {
        return this.platform;
    }

    public String getCommitHash() {
        return this.commitHash;
    }

    public static class Builder {
        private CoordinateType coordinateType;
        private String coordinate1;
        private String coordinate2;
        private String version;
        private String scope;
        private String platform;
        private String commitHash;

        @Deprecated
        @JsonSetter(value="buildType")
        public Builder withBuildType(BuildType buildType) {
            this.coordinateType = buildType == BuildType.PIP ? CoordinateType.PYPI : CoordinateType.toCoordType(buildType.name());
            return this;
        }

        public Builder withCoordinateType(CoordinateType coordinateType) {
            this.coordinateType = coordinateType;
            return this;
        }

        public Builder withCoordinate1(String coordinate1) {
            this.coordinate1 = coordinate1;
            return this;
        }

        public Builder withCoordinate2(String coordinate2) {
            this.coordinate2 = coordinate2;
            return this;
        }

        public Builder withCoordinates(String ... coords) {
            int len = coords.length;
            if (len < 1 || len > 2) {
                throw new IllegalArgumentException("Coords must be 1 or 2 in length");
            }
            this.coordinate1 = coords[0];
            if (len == 2) {
                this.coordinate2 = coords[1];
            }
            return this;
        }

        public Builder withVersion(String version) {
            this.version = version;
            return this;
        }

        public Builder withScope(String scope) {
            this.scope = scope;
            return this;
        }

        public Builder withPlatform(String platform) {
            this.platform = platform;
            return this;
        }

        public Builder withCommitHash(String commitHash) {
            this.commitHash = commitHash;
            return this;
        }

        public Coords build() {
            return new Coords(this);
        }
    }
}

