/*
 * Decompiled with CFR 0.152.
 */
package com.srcclr.sdk.build;

import com.srcclr.sdk.CoordinateType;
import com.srcclr.sdk.Coords;
import com.srcclr.sdk.LibraryGraph;
import com.srcclr.sdk.LibraryJGraphT;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.shared.dependency.graph.DependencyNode;

@Immutable
public class MavenComponentGraphBuilder {
    public LibraryGraph buildGraph(DependencyNode node, String relativePathToPom) throws MojoExecutionException {
        return this.buildGraph(node, relativePathToPom, null);
    }

    public LibraryGraph buildGraph(DependencyNode node, String relativePathToPom, @Nullable ArtifactFilter filter) throws MojoExecutionException {
        if (node == null) {
            throw new MojoExecutionException("Maven unexpectedly found a null dependency graph node");
        }
        return this.convertToLibraryGraphBuilder(node, relativePathToPom).withDirects(this.buildGraphRecursively(node.getChildren(), relativePathToPom, filter, true)).build();
    }

    private Set<LibraryGraph> buildGraphRecursively(Collection<DependencyNode> nodes, String relativePathToPom, @Nullable ArtifactFilter filter, boolean isDirect) throws MojoExecutionException {
        HashSet<LibraryGraph> result = new HashSet<LibraryGraph>();
        if (nodes == null) {
            return result;
        }
        for (DependencyNode currentNode : nodes) {
            if (currentNode == null) {
                throw new MojoExecutionException("Maven unexpectedly found a null dependency graph node");
            }
            Artifact nodeArtifact = currentNode.getArtifact();
            List children = currentNode.getChildren();
            if (filter == null || filter.include(nodeArtifact)) {
                result.add(this.convertToLibraryGraphBuilder(currentNode, relativePathToPom).withDirects(this.buildGraphRecursively(children, relativePathToPom, filter, false)).build());
                continue;
            }
            if (isDirect) {
                Set<LibraryGraph> childrenLibraryGraphs = this.buildGraphRecursively(children, relativePathToPom, filter, false);
                if (childrenLibraryGraphs.isEmpty()) continue;
                result.add(this.createUndefinedGraphBuilder(currentNode, relativePathToPom).withDirects(childrenLibraryGraphs).build());
                continue;
            }
            result.addAll(this.buildGraphRecursively(children, relativePathToPom, filter, false));
        }
        return result;
    }

    public LibraryGraph buildGraphWithJGraphT(DependencyNode node, String relativePathToPom) throws MojoExecutionException {
        return this.buildGraphWithJGraphT(node, relativePathToPom, null);
    }

    public LibraryGraph buildGraphWithJGraphT(DependencyNode node, String relativePathToPom, @Nullable ArtifactFilter filter) throws MojoExecutionException {
        if (node == null) {
            throw new MojoExecutionException("Maven unexpectedly found a null dependency graph node");
        }
        LibraryJGraphT graph = new LibraryJGraphT(this.convertToLibraryGraphBuilder(node, relativePathToPom));
        this.buildJGraphT(graph, graph.root(), node.getChildren(), relativePathToPom, filter, true);
        return graph.toLibraryGraph();
    }

    private long buildJGraphT(LibraryJGraphT graph, LibraryGraph.Builder parent, Collection<DependencyNode> nodes, String filename, @Nullable ArtifactFilter filter, boolean isDirect) throws MojoExecutionException {
        long graphSize = 0L;
        if (nodes == null) {
            return graphSize;
        }
        for (DependencyNode currentNode : nodes) {
            LibraryGraph.Builder builder;
            if (currentNode == null) {
                throw new MojoExecutionException("Maven unexpectedly found a null dependency graph node");
            }
            Artifact nodeArtifact = currentNode.getArtifact();
            List children = currentNode.getChildren();
            if (filter == null || filter.include(nodeArtifact)) {
                builder = this.convertToLibraryGraphBuilder(currentNode, filename);
                ++graphSize;
                if (!graph.dependsOn(parent, builder)) continue;
                graphSize += this.buildJGraphT(graph, builder, children, filename, filter, false);
                continue;
            }
            if (isDirect) {
                builder = this.createUndefinedGraphBuilder(currentNode, filename);
                long childrenGraphSize = this.buildJGraphT(graph, builder, children, filename, filter, false);
                if (childrenGraphSize <= 0L) continue;
                assert (graph.dependsOn(parent, builder));
                graphSize += childrenGraphSize + 1L;
                continue;
            }
            graphSize += this.buildJGraphT(graph, parent, children, filename, filter, false);
        }
        return graphSize;
    }

    private LibraryGraph.Builder createUndefinedGraphBuilder(DependencyNode node, String filename) {
        Artifact nodeArtifact = node.getArtifact();
        Coords coords = new Coords.Builder().withCoordinateType(CoordinateType.MAVEN).withCoordinates("<undefined>", "<undefined>").withVersion("<undefined>").withScope(nodeArtifact.getScope()).build();
        return new LibraryGraph.Builder().withCoords(coords).withFilename(filename);
    }

    private LibraryGraph.Builder convertToLibraryGraphBuilder(DependencyNode node, String filename) {
        Artifact nodeArtifact = node.getArtifact();
        Coords coords = new Coords.Builder().withCoordinateType(CoordinateType.MAVEN).withCoordinates(nodeArtifact.getGroupId(), nodeArtifact.getArtifactId()).withVersion(nodeArtifact.getVersion()).withScope(nodeArtifact.getScope()).build();
        return new LibraryGraph.Builder().withCoords(coords).withFilename(filename);
    }
}

