/*
 * Decompiled with CFR 0.152.
 */
package com.veracode.security.logging;

import com.veracode.security.logging.SecureLoggerUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.IdentityHashMap;

public class SecureExceptionWrapper
extends Throwable {
    private static final long serialVersionUID = 8537216311600073338L;
    private final Throwable wrappedThrowable;
    private String cleansedStackTrace;
    public static final String THROWABLE_CYCLE = "<cycle in throwable graph>";

    public SecureExceptionWrapper(Throwable wrappedThrowable) {
        this.wrappedThrowable = wrappedThrowable;
        this.getStackTraceString();
    }

    @Override
    public synchronized Throwable getCause() {
        return this.wrappedThrowable.getCause();
    }

    @Override
    public StackTraceElement[] getStackTrace() {
        return this.wrappedThrowable.getStackTrace();
    }

    @Override
    public void setStackTrace(StackTraceElement[] stackTrace) {
        this.wrappedThrowable.setStackTrace(stackTrace);
    }

    @Override
    public String toString() {
        return SecureLoggerUtil.escapeMessage(this.wrappedThrowable.toString());
    }

    @Override
    public String getLocalizedMessage() {
        return SecureLoggerUtil.escapeMessage(this.wrappedThrowable.getLocalizedMessage());
    }

    @Override
    public String getMessage() {
        return SecureLoggerUtil.escapeMessage(this.wrappedThrowable.getMessage());
    }

    @Override
    public void printStackTrace(PrintWriter printWriter) {
        printWriter.write(this.getStackTraceString());
    }

    @Override
    public void printStackTrace(PrintStream printStream) {
        printStream.println(this.getStackTraceString());
    }

    @Override
    public void printStackTrace() {
        this.wrappedThrowable.printStackTrace();
        System.err.println(this.getStackTraceString());
    }

    public String getStackTraceString() {
        if (this.cleansedStackTrace == null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                baos = this.stackTraceString(baos, "", this.wrappedThrowable, new IdentityHashMap<Throwable, Boolean>());
                this.cleansedStackTrace = new String(baos.toByteArray(), Charset.defaultCharset());
            }
            catch (IOException e) {
                this.cleansedStackTrace = "ERROR: " + SecureLoggerUtil.escapeMessage(e.toString());
            }
        }
        return this.cleansedStackTrace;
    }

    private ByteArrayOutputStream stackTraceString(ByteArrayOutputStream baos, String indent, Throwable throwable, IdentityHashMap<Throwable, Boolean> visitedNodes) throws IOException {
        Throwable cause;
        Throwable[] suppressedExceptions;
        String throwableString = throwable.toString();
        String cleansedString = SecureLoggerUtil.escapeMessage(throwableString);
        baos.write(indent.getBytes());
        baos.write(cleansedString.getBytes());
        baos.write("\n".getBytes());
        if (visitedNodes.containsKey(throwable)) {
            baos.write(indent.getBytes());
            baos.write(THROWABLE_CYCLE.getBytes());
            return baos;
        }
        visitedNodes.put(throwable, true);
        StackTraceElement[] stack = throwable.getStackTrace();
        if (stack != null) {
            for (StackTraceElement aStack : stack) {
                baos.write(indent.getBytes());
                baos.write("\tat ".getBytes());
                baos.write(aStack.toString().getBytes());
                baos.write("\n".getBytes());
            }
        }
        if ((suppressedExceptions = throwable.getSuppressed()) != null) {
            for (Throwable t : suppressedExceptions) {
                baos.write(indent.getBytes());
                baos.write("\tSuppressed: \n".getBytes());
                this.stackTraceString(baos, indent + "\t", t, visitedNodes);
            }
        }
        if ((cause = throwable.getCause()) != null) {
            baos.write(indent.getBytes());
            baos.write("Caused by: \n".getBytes());
            this.stackTraceString(baos, indent + "\t", cause, visitedNodes);
        }
        return baos;
    }
}

