/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.util.system;

import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.SystemUtils;

public class OS {
    public static Path createDirectories(Path dir, FileAttribute<?> ... attrs) throws IOException {
        if (SystemUtils.IS_OS_WINDOWS) {
            return Files.createDirectories(dir, new FileAttribute[0]);
        }
        return Files.createDirectories(dir, attrs);
    }

    public static Path createTempFile(String prefix, String suffix, FileAttribute<?> ... attrs) throws IOException {
        if (SystemUtils.IS_OS_WINDOWS) {
            return Files.createTempFile(prefix, suffix, new FileAttribute[0]);
        }
        return Files.createTempFile(prefix, suffix, attrs);
    }

    public static Path setPosixFilePermissions(Path path, Set<PosixFilePermission> perms) throws IOException {
        if (SystemUtils.IS_OS_WINDOWS) {
            return path;
        }
        return Files.setPosixFilePermissions(path, perms);
    }

    public static List<String> path() {
        return OS.splitPathVariable(System.getenv("PATH"), File.pathSeparator);
    }

    public static List<String> splitPathVariable(String path, String pathSeparator) {
        if (Strings.isNullOrEmpty((String)path)) {
            return Collections.emptyList();
        }
        return Arrays.asList(path.split(pathSeparator));
    }
}

