/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.util.fingerprints;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.Sets;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TokenFingerprintResolver {
    private static final Pattern SEPARATORS = Pattern.compile("[\\.\\-_\\s:]");

    public String resolve(String token) {
        return this.format(this.split(token.toLowerCase()));
    }

    public String resolve(ImmutableCollection<String> resource) {
        TreeSet tokens = Sets.newTreeSet();
        for (String tokenString : resource) {
            tokens.addAll(this.split(tokenString));
        }
        return this.format(tokens);
    }

    private Set<String> split(String tokenString) {
        TreeSet set = Sets.newTreeSet();
        for (String token : SEPARATORS.split(tokenString.toLowerCase())) {
            if (token.isEmpty()) continue;
            set.add(token.toLowerCase());
        }
        return set;
    }

    private String format(Set<String> tokens) {
        StringBuilder sb = new StringBuilder();
        for (String token : tokens) {
            sb.append(token).append(":");
        }
        String str = sb.toString();
        return str.endsWith(":") ? str.substring(0, str.length() - 1) : str;
    }
}

