/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.util.fingerprints;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.sourceclear.util.fingerprints.TokenFingerprintResolver;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ManifestFingerprintResolver {
    private static final TokenFingerprintResolver TOKEN_RESOLVER = new TokenFingerprintResolver();
    private static final ImmutableList<ImmutableList<String>> ATTRIBUTES = ImmutableList.of((Object)ImmutableList.of((Object)"Implementation-Vendor-Id", (Object)"Implementation-Title"), (Object)ImmutableList.of((Object)"Bundle-SymbolicName"));

    public List<String> resolve(InputStream input) throws IOException {
        ArrayList<String> fingerprints = new ArrayList<String>();
        JarInputStream jarStream = new JarInputStream(input);
        Manifest mf = jarStream.getManifest();
        for (ImmutableList attributes : ATTRIBUTES) {
            String fingerprint = this.fingerprint(mf, (ImmutableList<String>)attributes);
            if (fingerprint == null) continue;
            fingerprints.add(fingerprint);
        }
        return fingerprints;
    }

    private String fingerprint(Manifest mf, ImmutableList<String> attributes) {
        ImmutableList list;
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (String attribute : attributes) {
            if (mf == null || mf.getMainAttributes() == null) break;
            String token = mf.getMainAttributes().getValue(attribute);
            if (token == null) continue;
            builder.add((Object)token);
        }
        if (!(list = builder.build()).isEmpty()) {
            return TOKEN_RESOLVER.resolve((ImmutableCollection<String>)list);
        }
        return null;
    }
}

