/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.util.config;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.sourceclear.api.data.artifact.ArtifactComponent;
import com.sourceclear.api.data.artifact.LibraryArtifactApiModel;
import com.sourceclear.api.data.artifact.LibraryMatchWithArtifactsApiModel;
import com.sourceclear.api.data.artifact.VersionRange;
import com.sourceclear.api.data.evidence.LibraryModel;
import com.sourceclear.api.data.match.MatchResponse;
import com.sourceclear.util.config.Commons;
import com.sourceclear.util.io.renderers.ScanReport;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ScanResultsValue {
    private static final String FAILON_MSG_FORMAT = "FailOn level set to %s.";
    private static final String REASON_FORMAT = "Found %s vulnerabilities equal or higher than %s severity, and %s vulnerable methods.";
    private static final String REASON_METHODS_FORMAT = "Found %s vulnerable methods.";
    private static final String FAIL_ON_UNFIXABLE = "FAIL_ON_UNFIXABLE";
    private final ScanReport scanReport;
    private final ImmutableMap<String, Object> scanAttributes;
    private int exitValue;
    private String message = "";

    private static boolean failOnUnfixable(ImmutableMap<String, Object> scanAttributes) {
        boolean failOnUnfixable = true;
        Object key = scanAttributes.get((Object)FAIL_ON_UNFIXABLE);
        if (key != null) {
            failOnUnfixable = Boolean.parseBoolean(key.toString());
        }
        return failOnUnfixable;
    }

    protected static boolean isFixable(LibraryMatchWithArtifactsApiModel artifact) {
        boolean isFixable = true;
        for (LibraryArtifactApiModel art : artifact.getArtifacts()) {
            for (ArtifactComponent comp : art.getArtifactComponents()) {
                for (VersionRange range : comp.getVersionRanges()) {
                    isFixable &= !Strings.isNullOrEmpty((String)range.getUpdateToVersion());
                }
            }
        }
        return isFixable;
    }

    public ScanResultsValue(@Nonnull ScanReport scanReport, @Nonnull ImmutableMap<String, Object> scanAttributes) throws Exception {
        this.scanReport = scanReport;
        this.scanAttributes = scanAttributes;
        this.setExitValueAndMessage();
    }

    public int getExitValue() {
        return this.exitValue;
    }

    public String getMessage() {
        return this.message;
    }

    private void setExitValueAndMessage() throws Exception {
        Commons.VulnLevels failOn = this.scanReport.getFailOnLevel();
        if (failOn.equals((Object)Commons.VulnLevels.NEVER)) {
            this.exitValue = failOn.getExitValue();
            this.message = String.format(FAILON_MSG_FORMAT, new Object[]{failOn});
        } else if (failOn.equals((Object)Commons.VulnLevels.METHODS)) {
            int vulnMethods = this.countVulnMethods();
            this.exitValue = vulnMethods > 0 ? failOn.getExitValue() : 0;
            String levelMsg = String.format(FAILON_MSG_FORMAT, new Object[]{failOn});
            String reasonMsg = String.format(REASON_METHODS_FORMAT, vulnMethods);
            this.message = levelMsg + " " + reasonMsg;
        } else {
            Commons.Severity severity = this.convertFailOnToSeverity(failOn);
            int vulnMethods = this.countVulnMethods();
            int equalOrHigherLevelVulns = this.countVulnsEqualOrHigherThan(severity, ScanResultsValue.failOnUnfixable(this.scanAttributes));
            this.exitValue = vulnMethods > 0 || equalOrHigherLevelVulns > 0 ? failOn.getExitValue() : 0;
            String levelMsg = String.format(FAILON_MSG_FORMAT, new Object[]{failOn});
            String reasonMsg = String.format(REASON_FORMAT, new Object[]{equalOrHigherLevelVulns, severity, vulnMethods});
            this.message = levelMsg + " " + reasonMsg;
        }
    }

    private int countVulnMethods() {
        return this.scanReport.getVulnerableMethods() == null ? 0 : this.scanReport.getVulnerableMethods();
    }

    private int countVulnsEqualOrHigherThan(Commons.Severity severityThreshold, boolean failOnUnfixable) {
        int count = 0;
        MatchResponse matchResponse = this.scanReport.getMatchResponse();
        for (LibraryMatchWithArtifactsApiModel libWithArt : matchResponse.getComponents()) {
            LibraryModel component = libWithArt.getComponent();
            if (component == null) continue;
            boolean isFixable = ScanResultsValue.isFixable(libWithArt);
            Set<LibraryArtifactApiModel> artifacts = libWithArt.getArtifacts();
            for (LibraryArtifactApiModel artifact : artifacts) {
                Commons.Severity artifactSeverity = Commons.determineSeverity(artifact);
                if (artifactSeverity.compareTo(severityThreshold) < 0 || !isFixable && !failOnUnfixable) continue;
                ++count;
            }
        }
        return count;
    }

    private Commons.Severity convertFailOnToSeverity(Commons.VulnLevels failOn) throws Exception {
        if (failOn.equals((Object)Commons.VulnLevels.LOW)) {
            return Commons.Severity.Low;
        }
        if (failOn.equals((Object)Commons.VulnLevels.MEDIUM)) {
            return Commons.Severity.Medium;
        }
        if (failOn.equals((Object)Commons.VulnLevels.HIGH)) {
            return Commons.Severity.High;
        }
        if (failOn.equals((Object)Commons.VulnLevels.CRITICAL)) {
            return Commons.Severity.Critical;
        }
        throw new Exception("No conversion from FailOn level " + (Object)((Object)failOn) + " to Severity.");
    }
}

