/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.sgl.lang.printer;

import com.google.common.collect.ImmutableSet;
import com.sourceclear.sgl.SGL;
import com.sourceclear.sgl.lang.ASTVisitor;
import com.sourceclear.sgl.lang.BindingExpansionVisitor;
import com.sourceclear.sgl.lang.ExpandWithin;
import com.sourceclear.sgl.lang.PredicateVisitor;
import com.sourceclear.sgl.lang.argument.Argument;
import com.sourceclear.sgl.lang.argument.PredicateArgument;
import com.sourceclear.sgl.lang.argument.StepArgument;
import com.sourceclear.sgl.lang.argument.WildcardArgument;
import com.sourceclear.sgl.lang.expr.AddAction;
import com.sourceclear.sgl.lang.expr.BindingSequence;
import com.sourceclear.sgl.lang.expr.Expr;
import com.sourceclear.sgl.lang.expr.Patterns;
import com.sourceclear.sgl.lang.expr.Query;
import com.sourceclear.sgl.lang.expr.RemoveAction;
import com.sourceclear.sgl.lang.expr.Sequence;
import com.sourceclear.sgl.lang.predicate.And;
import com.sourceclear.sgl.lang.predicate.Eq;
import com.sourceclear.sgl.lang.predicate.Neg;
import com.sourceclear.sgl.lang.predicate.Or;
import com.sourceclear.sgl.lang.predicate.Regex;
import com.sourceclear.sgl.lang.predicate.Relational;
import com.sourceclear.sgl.lang.predicate.Within;
import com.sourceclear.sgl.lang.printer.ASTPrinter;
import com.sourceclear.sgl.lang.step.Step;
import java.util.List;
import java.util.stream.Collectors;

public class QueryNormalizer
extends ASTVisitor<Expr, Step, Void>
implements PredicateVisitor<Void> {
    private static final ImmutableSet<String> allowedVertexSteps = ImmutableSet.of((Object)"vulnerability", (Object)"version_range", (Object)"library", (Object)"method");
    private static final ImmutableSet<String> allowedEdgeSteps = ImmutableSet.of((Object)"has_version_range", (Object)"has_library", (Object)"has_vulnerable_method");

    public static String normalizeAndPrint(String query) {
        return ASTPrinter.print(QueryNormalizer.normalize(query));
    }

    public static Expr normalize(String query) {
        return QueryNormalizer.normalize(SGL.parse(query));
    }

    public static Expr normalize(Expr query) {
        return BindingExpansionVisitor.expand(query).accept(new QueryNormalizer());
    }

    @Override
    public Expr visitBindingSequence(BindingSequence bindingSequence) {
        throw new RuntimeException("bindings should all have been expanded by now");
    }

    @Override
    public Expr visitSequence(Sequence sequence) {
        this.isNotSupported("SGDL");
        return null;
    }

    @Override
    public Expr visitAddAction(AddAction action) {
        this.isNotSupported("SGDL");
        return null;
    }

    @Override
    public Expr visitRemoveAction(RemoveAction action) {
        this.isNotSupported("SGDL");
        return null;
    }

    @Override
    public Expr visitQuery(Query query) {
        return new Query(query.getStep().accept(this));
    }

    @Override
    public Expr visitPatterns(Patterns patterns) {
        this.isNotSupported("arbitrary patterns");
        return null;
    }

    @Override
    public Step visitStep(Step step) {
        String name = step.getName();
        if (allowedVertexSteps.contains((Object)name)) {
            step.getArguments().forEach(a -> {
                if (a instanceof StepArgument) {
                    throw new RuntimeException(a + " is not a valid argument, as vertex steps cannot take traversals");
                }
                if (a instanceof PredicateArgument) {
                    if (!(((PredicateArgument)a).getPredicate() instanceof Eq)) {
                        throw new RuntimeException("predicates like " + a + " are only valid inside unions");
                    }
                } else if (a instanceof WildcardArgument) {
                    this.isNotSupported("use of wildcards");
                }
            });
            step.getArguments().forEach(Argument::asValue);
            List<Argument> args = step.getArguments();
            return step.getNext().map(n -> new Step(name, args, n.accept(this))).orElseGet(() -> new Step(name, args));
        }
        if (allowedEdgeSteps.contains((Object)name)) {
            if (!step.getArguments().isEmpty()) {
                throw new RuntimeException("the edge " + name + " cannot have arguments");
            }
            return step.getNext().map(n -> new Step(name, n.accept(this))).orElseThrow(() -> new RuntimeException("the edge " + name + " cannot end a step"));
        }
        if (name.equals("union")) {
            List<Argument> expanded = step.getArguments().stream().map(Argument::asStep).map(StepArgument::getStep).map(s -> s).flatMap(ExpandWithin::computeRecursively).map(this::visit).map(Argument::of).collect(Collectors.toList());
            return new Step(name, expanded);
        }
        throw new RuntimeException("step " + name + " is not allowed");
    }

    @Override
    public Void visitPredicateArgument(PredicateArgument predicateArgument) {
        return QueryNormalizer.notHandledHere();
    }

    @Override
    public Void visitTraversalArgument(StepArgument stepArgument) {
        return QueryNormalizer.notHandledHere();
    }

    @Override
    public Void visitWildcardArgument(WildcardArgument wildcardArgument) {
        return QueryNormalizer.notHandledHere();
    }

    @Override
    public Void visitAnd(And and) {
        return QueryNormalizer.notHandledHere();
    }

    @Override
    public Void visitOr(Or or) {
        return QueryNormalizer.notHandledHere();
    }

    @Override
    public Void visitNot(Neg neg) {
        return QueryNormalizer.notHandledHere();
    }

    @Override
    public Void visitRelational(Relational relational) {
        return QueryNormalizer.notHandledHere();
    }

    @Override
    public Void visitWithin(Within within) {
        return QueryNormalizer.notHandledHere();
    }

    @Override
    public Void visitEq(Eq eq) {
        return QueryNormalizer.notHandledHere();
    }

    @Override
    public Void visitRegex(Regex regex) {
        return QueryNormalizer.notHandledHere();
    }

    private Void isNotSupported(String thing) {
        throw new RuntimeException(thing + " isn't supported in queries");
    }

    private static Void notHandledHere() {
        throw new IllegalStateException("not handled here");
    }
}

