/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.sgl.lang;

import com.sourceclear.sgl.lang.argument.Argument;
import com.sourceclear.sgl.lang.argument.PredicateArgument;
import com.sourceclear.sgl.lang.predicate.Eq;
import com.sourceclear.sgl.lang.predicate.Predicate;
import com.sourceclear.sgl.lang.predicate.Within;
import com.sourceclear.sgl.lang.step.Step;
import com.sourceclear.sgl.lang.value.Value;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

public class ExpandWithin {
    private final List<Argument> state = new ArrayList<Argument>();
    private final List<Step> result = new ArrayList<Step>();

    public static Stream<Step> compute(Step step) {
        if (!step.getArguments().stream().allMatch(a -> a instanceof PredicateArgument)) {
            ExpandWithin.fail();
        }
        ExpandWithin expandWithin = new ExpandWithin();
        expandWithin.compute(step, 0);
        return expandWithin.result.stream();
    }

    public static Stream<Step> computeRecursively(Step step) {
        return step.getNext().map(n -> ExpandWithin.compute(step).flatMap(s -> ExpandWithin.computeRecursively(n).map(s::concat))).orElseGet(() -> ExpandWithin.compute(step));
    }

    private void compute(Step step, int i) {
        int max = step.getArguments().size();
        if (i >= max) {
            this.result.add(new Step(step.getName(), new ArrayList<Argument>(this.state)));
        } else {
            Argument a = step.getArguments().get(i);
            Predicate p = ((PredicateArgument)a).getPredicate();
            if (p instanceof Eq) {
                this.state.add(a);
                this.compute(step, i + 1);
                this.state.remove(i);
            } else if (p instanceof Within) {
                for (Value value : ((Within)p).getValues()) {
                    this.state.add(a.getKeyword().map(k -> new PredicateArgument((String)k, new Eq(value))).orElseGet(() -> new PredicateArgument(new Eq(value))));
                    this.compute(step, i + 1);
                    this.state.remove(i);
                }
            } else {
                ExpandWithin.fail();
            }
        }
    }

    private static void fail() {
        throw new RuntimeException("the start step only works with within predicates or literals");
    }
}

