/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.scm.core;

import javax.annotation.concurrent.Immutable;

@Immutable
public final class SCMAuth {
    private final String username;
    private final String password;
    private final String authToken;

    private SCMAuth(Builder builder) {
        this.authToken = builder.authToken;
        this.password = builder.password;
        this.username = builder.username;
    }

    public String getAuthToken() {
        return this.authToken;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public static class Builder {
        private String authToken;
        private String username;
        private String password;

        public Builder withAuthToken(String authToken) {
            this.authToken = authToken;
            return this;
        }

        public Builder withUsername(String username) {
            this.username = username;
            return this;
        }

        public Builder withPassword(String password) {
            this.password = password;
            return this;
        }

        public SCMAuth build() {
            return new SCMAuth(this);
        }
    }
}

