/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.plugins;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.sourceclear.engine.common.FeatureFlag;
import com.sourceclear.plugins.Config;
import com.sourceclear.plugins.DefaultLifecycle;
import com.sourceclear.plugins.HeadlessLifecycle;
import com.sourceclear.plugins.Lifecycle;
import com.sourceclear.util.config.EnvironmentProvider;
import com.sourceclear.util.config.EnvironmentProviderImpl;
import com.sourceclear.util.config.FailureLevel;
import com.srcclr.sdk.Directives;
import com.srcclr.sdk.LibraryGraph;
import com.srcclr.sdk.LibraryGraphContainer;
import com.srcclr.sdk.build.MavenComponentGraphBuilder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.InstantiationStrategy;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;

@Mojo(name="scan", requiresDependencyCollection=ResolutionScope.TEST, instantiationStrategy=InstantiationStrategy.SINGLETON)
public class ScanMavenMojo
extends AbstractMojo {
    static final String DEPRECATED_SCOPE_ENV_VAR = "SRCCLR_SCAN_SCOPE";
    static final String SCOPE_ENV_VAR = "SRCCLR_SCOPE";
    private static final String DIRECTIVES_FILE_NAME = "srcclr.yml";
    static final Path DIRECTIVES_FILE = Paths.get("srcclr.yml", new String[0]);
    private static final String DIRECTIVES_SCOPE_KEY = "scope";
    static final String DEFAULT_SCOPE = "compile";
    static final String TMP_GRAPH_FILE_NAME = "srcclr-graph-3409538450765745928495.json";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    MavenSession session;
    @Parameter(defaultValue="${settings}", readonly=true, required=true)
    public Settings settings;
    @Parameter(property="projectName")
    private String projectName;
    @Parameter(property="apiURL")
    protected URI apiURL;
    @Parameter(property="apiToken")
    protected String apiToken;
    @Parameter(property="upload", defaultValue="true")
    private boolean upload;
    @Parameter(property="verbose", defaultValue="false")
    private boolean verbose;
    @Parameter(property="useOnlyMavenParams", defaultValue="false")
    private boolean useOnlyMavenParams;
    @Parameter(property="srcclr.maven.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="srcclr.license.provided", defaultValue="false")
    private boolean licenseProvided;
    @Parameter(property="headlessOutputFile")
    private File headlessOutputFile;
    @Parameter(property="workspaceSlug")
    protected String workspaceSlug;
    @Parameter(property="failureThreshold")
    private FailureLevel failureThreshold;
    @Parameter(property="scope")
    String scopeParameter;
    @Component(hint="default")
    private DependencyGraphBuilder dependencyGraphBuilder;
    EnvironmentProvider environmentProvider = new EnvironmentProviderImpl();
    MavenProject lastProject;
    private String pluginVersion;

    protected File getPathToTop() {
        if (this.session != null) {
            return this.session.getTopLevelProject().getFile().getParentFile();
        }
        this.getLog().warn((CharSequence)"Couldn't figure out the top level of the Maven project.");
        return new File(".");
    }

    @VisibleForTesting
    void initialSetup() {
        this.pluginVersion = ((PluginDescriptor)this.getPluginContext().get("pluginDescriptor")).getVersion();
        if (this.lastProject == null) {
            List sortedProjects = this.session.getProjectDependencyGraph().getSortedProjects();
            this.lastProject = (MavenProject)sortedProjects.get(sortedProjects.size() - 1);
        }
    }

    LibraryGraph getProjectDependencyGraph() throws MojoExecutionException, MojoFailureException {
        try {
            DefaultProjectBuildingRequest buildRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
            MavenProject currentProject = this.session.getCurrentProject();
            buildRequest.setProject(currentProject);
            buildRequest.setResolveDependencies(true);
            Path pathToCurrPom = currentProject.getFile().toPath();
            String relativePathToCurrPom = Paths.get(this.getPathToTop().toString(), new String[0]).relativize(pathToCurrPom).toString();
            MavenComponentGraphBuilder graphTranslator = new MavenComponentGraphBuilder();
            DependencyNode mavenDependencyTree = this.dependencyGraphBuilder.buildDependencyGraph((ProjectBuildingRequest)buildRequest, null);
            if (!Boolean.valueOf(String.valueOf(this.environmentProvider.getenv("SRCCLR_" + FeatureFlag.Flag.ENABLE_MAVEN_NATIVE_COLLECTOR_JGRAPHT.getDirective().toUpperCase()))).booleanValue()) {
                return graphTranslator.buildGraph(mavenDependencyTree, relativePathToCurrPom, (ArtifactFilter)new ScopeArtifactFilter(this.getScope()));
            }
            return graphTranslator.buildGraphWithJGraphT(mavenDependencyTree, relativePathToCurrPom, (ArtifactFilter)new ScopeArtifactFilter(this.getScope()));
        }
        catch (DependencyGraphBuilderException e) {
            throw new MojoExecutionException("Encountered problem running the SRC:CLR maven plugin: " + e.getMessage());
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping the SRC:CLR Maven Plugin because srcclr.maven.skip is set");
            return;
        }
        this.initialSetup();
        Config config = Config.builder().withPluginVersion(this.pluginVersion).withApiToken(this.apiToken).withApiURL(this.apiURL).withFailureThreshold(this.failureThreshold).withLogger(this.getLog()).withLicenseProvided(this.licenseProvided).withProjectName(this.projectName).withPathToTop(this.getPathToTop()).withSettings(this.settings).withUpload(this.upload).withUseOnlyMavenParams(this.useOnlyMavenParams).withHeadlessOutputFile(this.headlessOutputFile).withVerbose(this.verbose).withWorkspaceSlug(this.workspaceSlug).build();
        Lifecycle lifecycle = this.configureLifecycle(config);
        try {
            this.saveDependencyGraph(this.getProjectDependencyGraph());
            if (this.lastProject.equals((Object)this.session.getCurrentProject())) {
                lifecycle.execute(this.buildDependencyTrees());
            }
        }
        catch (Throwable e) {
            ScanMavenMojo.getTmpGraphFileInProject(this.session.getCurrentProject()).delete();
            throw e;
        }
    }

    static Lifecycle determineLifecycle(Config config) {
        if (config.getHeadlessOutputFile().isPresent()) {
            return new HeadlessLifecycle(config.getHeadlessOutputFile().get());
        }
        return new DefaultLifecycle(config);
    }

    String getScope() throws MojoFailureException {
        String scope;
        String envVarScope = this.environmentProvider.getenv(SCOPE_ENV_VAR);
        String deprecatedEnvVarScope = this.environmentProvider.getenv(DEPRECATED_SCOPE_ENV_VAR);
        if (envVarScope != null) {
            scope = envVarScope;
        } else if (deprecatedEnvVarScope != null) {
            this.getLog().warn((CharSequence)"Using deprecated SRCCLR_SCAN_SCOPE environment variable: Please use SRCCLR_SCOPE instead.");
            scope = deprecatedEnvVarScope;
        } else {
            scope = this.scopeParameter != null ? this.scopeParameter : (Files.exists(DIRECTIVES_FILE, new LinkOption[0]) ? ScanMavenMojo.getScopeFromDirectivesFile(DIRECTIVES_FILE) : DEFAULT_SCOPE);
        }
        return ScanMavenMojo.toArtifactScopeValue(scope);
    }

    static String getScopeFromDirectivesFile(Path directivesFile) throws MojoFailureException {
        String scope;
        try (InputStream is = Files.newInputStream(directivesFile, new OpenOption[0]);){
            Map directives = Directives.parseDirectives((InputStream)is);
            String scopeValue = (String)directives.get(DIRECTIVES_SCOPE_KEY);
            scope = scopeValue != null ? scopeValue : DEFAULT_SCOPE;
        }
        catch (IOException e) {
            throw new MojoFailureException(e.getMessage());
        }
        return scope;
    }

    static String toArtifactScopeValue(String scope) {
        switch (scope) {
            case "compile": 
            case "test": 
            case "import": 
            case "runtime": 
            case "provided": 
            case "system": 
            case "compile+runtime": 
            case "runtime+system": {
                return scope;
            }
        }
        return DEFAULT_SCOPE;
    }

    void saveDependencyGraph(LibraryGraph graph) throws MojoExecutionException {
        MavenProject project = this.session.getCurrentProject();
        File graphFile = ScanMavenMojo.getTmpGraphFileInProject(project);
        if (graphFile.exists()) {
            graphFile.delete();
        }
        try {
            MAPPER.writeValue(graphFile, (Object)graph);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failure writing data to srcclr-graph-3409538450765745928495.json: " + e.getMessage());
        }
    }

    LibraryGraphContainer buildDependencyTrees() throws MojoExecutionException {
        LibraryGraphContainer.Builder projectDependencyTreesBuilder = new LibraryGraphContainer.Builder();
        while (!this.allModulesFinished()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new MojoExecutionException("Interruption detected: " + e.getMessage());
            }
        }
        for (MavenProject project : this.session.getProjectDependencyGraph().getSortedProjects()) {
            File graphFile = ScanMavenMojo.getTmpGraphFileInProject(project);
            try {
                projectDependencyTreesBuilder.withGraph((LibraryGraph)MAPPER.readValue(graphFile, LibraryGraph.class));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failure reading graph file " + graphFile.getAbsolutePath() + ": " + e.getMessage());
            }
            graphFile.delete();
        }
        return projectDependencyTreesBuilder.build();
    }

    private boolean allModulesFinished() {
        for (MavenProject project : this.session.getProjectDependencyGraph().getSortedProjects()) {
            File graphFile = ScanMavenMojo.getTmpGraphFileInProject(project);
            if (graphFile.exists()) continue;
            return false;
        }
        return true;
    }

    private static File getTmpGraphFileInProject(MavenProject project) {
        return project.getBasedir().toPath().resolve(TMP_GRAPH_FILE_NAME).toFile();
    }

    Lifecycle configureLifecycle(Config config) throws MojoFailureException {
        Lifecycle lifecycle = ScanMavenMojo.determineLifecycle(config);
        lifecycle.configure(this.environmentProvider);
        return lifecycle;
    }
}

