/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.plugins;

import com.google.common.annotations.VisibleForTesting;
import com.sourceclear.api.client.Client;
import com.sourceclear.api.client.SourceClearClient;
import com.sourceclear.api.data.LicenseData;
import com.sourceclear.api.data.evidence.BuildType;
import com.sourceclear.api.data.evidence.LanguageType;
import com.sourceclear.engine.scan.LibraryGraphContainerScanner;
import com.sourceclear.engine.scan.SrcclrScanFailureException;
import com.sourceclear.engine.scan.SrcclrScanUnexpectedCondition;
import com.sourceclear.plugins.Config;
import com.sourceclear.plugins.Lifecycle;
import com.sourceclear.plugins.Utils;
import com.sourceclear.util.config.ConfigException;
import com.sourceclear.util.config.EnvironmentProvider;
import com.sourceclear.util.config.LicenseDataCheck;
import com.sourceclear.util.config.LicenseDataException;
import com.sourceclear.util.config.ScanConfig;
import com.sourceclear.util.config.Verbosity;
import com.srcclr.sdk.LibraryGraphContainer;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.settings.Settings;

class DefaultLifecycle
implements Lifecycle {
    private ScanConfig scanConfig;
    private Client sourceclearClient;
    private final Config config;
    private final Log logger;
    private boolean withPolicy = false;
    private static final String API_TOKEN_ENV_VAR = "SRCCLR_API_TOKEN";
    private static final String API_URL_ENV_VAR = "SRCCLR_API_URL";
    private static final String LEGACY_MODE_ENV_VAR = "SRCCLR_LEGACY_MODE";
    private static final String SCM_NAME_ENV_VAR = "SRCCLR_SCM_NAME";
    private static final String SCM_URI_ENV_VAR = "SRCCLR_SCM_URI";
    private static final String WORKSPACE_SLUG = "SRCCLR_WORKSPACE_SLUG";

    public DefaultLifecycle(Config config) {
        this.config = config;
        this.logger = config.getLogger();
    }

    @Override
    public void configure(EnvironmentProvider environmentProvider) throws MojoFailureException {
        String projectName;
        URI apiURL;
        String apiToken;
        String apiTokenEnvVarValue = environmentProvider.getenv(API_TOKEN_ENV_VAR);
        if (!this.config.useOnlyMavenParams() && StringUtils.isNotBlank((String)apiTokenEnvVarValue)) {
            apiToken = apiTokenEnvVarValue;
        } else {
            if (StringUtils.isBlank((String)this.config.getApiToken())) {
                throw new MojoFailureException("Could not perform scan because an apiToken was not provided. Please provide it either through the \"apiToken\" Maven parameter or the \"SRCCLR_API_TOKEN\" environment variable");
            }
            apiToken = this.config.getApiToken();
        }
        String apiUrlEnvVarValue = environmentProvider.getenv(API_URL_ENV_VAR);
        if (!this.config.useOnlyMavenParams() && StringUtils.isNotBlank((String)apiUrlEnvVarValue)) {
            try {
                apiURL = new URI(apiUrlEnvVarValue);
            }
            catch (URISyntaxException ex) {
                throw new MojoFailureException(String.format("Invalid apiUrl value: %s", apiUrlEnvVarValue), (Throwable)ex);
            }
        } else {
            apiURL = this.config.getApiURL();
        }
        String projectNameEnvVarValue = environmentProvider.getenv(SCM_NAME_ENV_VAR);
        String projectNameFromURI = environmentProvider.getenv(SCM_URI_ENV_VAR);
        if (this.config.useOnlyMavenParams()) {
            projectName = this.config.getProjectName();
        } else if (StringUtils.isNotBlank((String)projectNameEnvVarValue)) {
            this.logger.warn((CharSequence)"Using deprecated environment variable: SRCCLR_SCM_NAME");
            projectName = projectNameEnvVarValue;
        } else {
            projectName = StringUtils.isNotBlank((String)projectNameFromURI) ? projectNameFromURI : this.config.getProjectName();
        }
        String wsEnvVarValue = environmentProvider.getenv(WORKSPACE_SLUG);
        String workspaceSlug = !this.config.useOnlyMavenParams() && StringUtils.isNotBlank((String)wsEnvVarValue) ? wsEnvVarValue : (String)this.config.getWorkspaceSlug().orElse(null);
        ScanConfig.Builder configBuilder = new ScanConfig.Builder().withLanguage(LanguageType.JAVA).withScanStart(System.currentTimeMillis()).withPathToTop(this.config.getPathToTop()).withApiURL(apiURL).withFailureThreshold(this.config.getFailureThreshold()).withProjectName(projectName).withUpload(this.config.getUpload()).withApiToken(apiToken).withScanID(String.format("maven-plugin-%s", UUID.randomUUID())).requireApiToken(true).withVerbosity(this.config.verbose() ? Verbosity.VERBOSE : Verbosity.NORMAL).withWorkspaceSlug(workspaceSlug).withClientType(BuildType.MAVEN);
        this.createClient(environmentProvider, apiToken, apiURL, this.config.getSettings());
        if (!this.config.licenseProvided()) {
            try {
                LicenseData licenseData = this.sourceclearClient.license();
                LicenseDataCheck.checkLicenseIsPaidOrThrow(licenseData);
                configBuilder.withLicenseData(licenseData);
            }
            catch (IOException ex) {
                throw new MojoFailureException("Could not acquire Team license data.", (Throwable)ex);
            }
            catch (LicenseDataException lde) {
                throw new MojoFailureException(lde.getMessage(), (Throwable)lde);
            }
        }
        try {
            this.scanConfig = configBuilder.build();
        }
        catch (ConfigException e) {
            throw new MojoFailureException("Encountered problem during configuration: ", (Throwable)e);
        }
    }

    @Override
    public void execute(LibraryGraphContainer dependencyTree) throws MojoFailureException, MojoExecutionException {
        LibraryGraphContainerScanner scanner = new LibraryGraphContainerScanner(this.scanConfig, this.sourceclearClient, this.withPolicy);
        try {
            scanner.consumeAndReport(dependencyTree);
        }
        catch (SrcclrScanFailureException e) {
            throw new MojoFailureException(e.getMessage());
        }
        catch (SrcclrScanUnexpectedCondition e) {
            throw new MojoExecutionException(e.getMessage());
        }
    }

    private void createClient(EnvironmentProvider environmentProvider, String apiToken, URI apiURL, Settings settings) throws MojoFailureException {
        boolean withPolicy;
        SourceClearClient.Builder builder = SourceClearClient.builder().withClientType(SourceClearClient.Type.MAVEN).withClientVersion(this.config.getPluginVersion()).withApiToken(apiToken).withBaseURI(apiURL);
        Utils.maybeSetProxy(builder, settings.getProxies());
        boolean bl = withPolicy = Boolean.valueOf(environmentProvider.getenv(LEGACY_MODE_ENV_VAR)) == false;
        if (withPolicy) {
            this.logger.debug((CharSequence)"Policy enabled");
            this.withPolicy = true;
        } else {
            this.logger.debug((CharSequence)"Legacy mode enabled.");
        }
        this.sourceclearClient = builder.withPolicy(withPolicy).build();
    }

    @VisibleForTesting
    ScanConfig getScanConfig() {
        return this.scanConfig;
    }
}

