/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.methods.js;

import com.sourceclear.analysis.latte.frameworks.Frameworks;
import com.sourceclear.analysis.latte.genids.Id;
import com.sourceclear.analysis.latte.genids.IdComponent;
import com.sourceclear.analysis.latte.staticCG.JavaScriptCallGraphs;
import com.sourceclear.methods.CallChainsInspector;
import com.sourceclear.methods.CallGraph;
import com.sourceclear.methods.CallGraphBuilder;
import com.sourceclear.methods.CallSite;
import com.sourceclear.methods.JSMethodInfo;
import com.sourceclear.methods.MethodInfo;
import com.sourceclear.methods.VulnMethodsConfig;
import com.sourceclear.methods.VulnMethodsInput;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class JSCallGraphBuilder
extends CallGraphBuilder {
    private static final String MOCHA = "mocha";
    private final Path projectRoot;
    private final VulnMethodsConfig config;
    private final Set<MethodInfo> methods = new HashSet<MethodInfo>();
    private final CallGraph callGraph = CallChainsInspector.createCallGraph();
    private boolean callGraphBuilt = false;

    public JSCallGraphBuilder(Path projectRoot, VulnMethodsConfig config) {
        this.projectRoot = projectRoot;
        this.config = config;
    }

    @Override
    public void build() throws IOException {
        if (this.callGraphBuilt) {
            return;
        }
        final HashSet files2 = new HashSet();
        Files.walkFileTree(this.projectRoot, (FileVisitor<? super Path>)new FileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                if (JSCallGraphBuilder.this.config.ignoredDirectories().contains(dir.getFileName().toString())) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                if (!JSCallGraphBuilder.isJSFile(file)) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                files2.add(JSCallGraphBuilder.this.projectRoot.resolve(file).toAbsolutePath().normalize());
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                return FileVisitResult.CONTINUE;
            }
        });
        JavaScriptCallGraphs.Companion.of(this.projectRoot, files2, (Set<Frameworks.Module>)this.frameworkMethods).forEach(this.callGraph::addEdge);
        this.callGraphBuilt = true;
    }

    @Override
    protected void augmentCallGraph(VulnMethodsInput input, CallGraph graph) {
        Set dynamicNodes = input.dynamicEdges().stream().flatMap(cs -> Stream.of(cs.getCaller(), cs.getCallee())).collect(Collectors.toSet());
        Set cgNodes = this.callGraph.vertices().collect(Collectors.toSet());
        input.dynamicEdges().stream().filter(e -> this.isRequireInNonTestLib((JSMethodInfo)e.getCaller())).filter(e -> this.isRequireInNonTestLib((JSMethodInfo)e.getCallee())).filter(e -> JSCallGraphBuilder.findSimilarMethodInGraph(dynamicNodes, e.getCaller()).size() == 1).map(edge -> {
            ArrayList<CallSite> list = new ArrayList<CallSite>();
            Collection<MethodInfo> callerCandidates = JSCallGraphBuilder.findSimilarMethodInGraph(cgNodes, edge.getCaller());
            Collection<MethodInfo> calleeCandidates = JSCallGraphBuilder.findSimilarMethodInGraph(cgNodes, edge.getCallee());
            for (MethodInfo caller : callerCandidates) {
                for (MethodInfo callee : calleeCandidates) {
                    if (!caller.getMethodName().equals(callee.getMethodName())) continue;
                    list.add(new CallSite(caller, callee, edge.getFileName(), edge.getLineNumber()));
                }
            }
            return list;
        }).flatMap(Collection::stream).forEach(graph::addEdge);
    }

    @Override
    public Set<MethodInfo> getMethodsDefined() {
        return this.methods;
    }

    @Override
    public boolean isTestMethod(MethodInfo m) {
        return this.config.ignoredDirectories().stream().anyMatch(dir -> m.getClassName().startsWith(dir + "/") && !this.isThirdParty(m));
    }

    @Override
    public boolean isTestFrameworkEntryPoint(CallSite callSite) {
        return JSCallGraphBuilder.isJSFile(callSite.getCallee()) && !this.isThirdParty(callSite.getCallee()) && this.isTestMethod(callSite.getCallee()) && JSCallGraphBuilder.isMochaFile(callSite.getCaller());
    }

    private boolean isThirdParty(MethodInfo methodInfo) {
        return methodInfo.getModuleName() != null;
    }

    @Override
    public CallGraph getCallGraph() {
        return this.callGraph;
    }

    private static boolean isJSFile(Path p) {
        return p.toString().endsWith(".mjs") || p.toString().endsWith(".js");
    }

    private static boolean isJSFile(MethodInfo methodInfo) {
        return methodInfo.getClassName().endsWith(".js") || methodInfo.getClassName().endsWith(".mjs");
    }

    private boolean isRequireInNonTestLib(JSMethodInfo methodInfo) {
        return Id.Companion.getGlobalIdentifier().equals(methodInfo.getId().getComponents().get(0)) && this.isThirdParty(methodInfo) && !JSCallGraphBuilder.isMochaFile(methodInfo);
    }

    private static boolean isMochaFile(MethodInfo methodInfo) {
        return MOCHA.equals(methodInfo.getModuleName());
    }

    private static Collection<MethodInfo> findSimilarMethodInGraph(Set<MethodInfo> nodes, MethodInfo globalNode) {
        JSMethodInfo jsMethodInfo = (JSMethodInfo)globalNode;
        String filename = jsMethodInfo.getId().getFilename();
        Id id = new Id(filename, Collections.singletonList(new IdComponent.Identifier("module", "exports")));
        String prefix = id.idComponentsToString().replace("*", ".");
        Set<MethodInfo> candidates = nodes.stream().filter(node -> Objects.equals(jsMethodInfo.getModuleName(), node.getModuleName()) && Objects.equals(node.getClassName(), jsMethodInfo.getClassName()) && node.getMethodName().startsWith(prefix)).collect(Collectors.toSet());
        if (candidates.isEmpty()) {
            candidates.add(new JSMethodInfo(jsMethodInfo.getModuleName(), id));
        }
        return candidates;
    }
}

