/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.methods;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sourceclear.methods.MethodDefinition;
import com.sourceclear.methods.MethodInfo;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.objectweb.asm.Type;

public class ClassInfo {
    @JsonProperty
    private final String className;
    @JsonProperty
    private final Optional<String> superName;
    private final boolean isInterface;
    private final Set<String> implementedInterfaces;
    @JsonProperty
    private final Set<MethodDefinition> methods;
    private final Map<MethodNameAndDesc, MethodInfo> methodNameAndDescToMethodInfo;
    private final Set<String> instantiatedTypes;
    private final Set<Type> reflectedClasses;
    private final Set<String> reflectedMethodNames;

    public ClassInfo(String className, String superName, Set<String> implementedInterfaces) {
        this(className, Collections.emptySet(), Optional.ofNullable(superName), false, implementedInterfaces, Collections.emptySet(), Collections.emptySet(), Collections.emptySet());
    }

    public ClassInfo(String className, String superName) {
        this(className, Collections.emptySet(), superName, Collections.emptySet());
    }

    public ClassInfo(String className, Set<MethodDefinition> methods, String superName) {
        this(className, methods, Optional.ofNullable(superName), false, Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet());
    }

    @JsonCreator
    public ClassInfo(@JsonProperty(value="class_name") String className, @JsonProperty(value="methods") Set<MethodDefinition> methods, @JsonProperty(value="super_name") String superName, @JsonProperty(value="instantiated_types") Set<String> instantiatedTypes) {
        this(className, methods, Optional.ofNullable(superName), false, Collections.emptySet(), instantiatedTypes, Collections.emptySet(), Collections.emptySet());
    }

    public ClassInfo(String className, Set<MethodDefinition> methods, Optional<String> superName, boolean isInterface, Set<String> implementedInterfaces, Set<String> instantiatedTypes, Set<Type> reflectedClasses, Set<String> reflectedMethodNames) {
        this.methods = Collections.unmodifiableSet(methods);
        this.superName = superName;
        this.implementedInterfaces = implementedInterfaces;
        this.instantiatedTypes = instantiatedTypes;
        this.reflectedClasses = reflectedClasses;
        this.reflectedMethodNames = reflectedMethodNames;
        this.methodNameAndDescToMethodInfo = methods.stream().filter(methodDefinition -> !methodDefinition.getAttributes().contains((Object)MethodDefinition.Attribute.SYNTHETIC)).collect(Collectors.toMap(methodDefinition -> new MethodNameAndDesc(methodDefinition.getMethod().getMethodName(), methodDefinition.getMethod().getDesc()), MethodDefinition::getMethod, (x, _y) -> x));
        this.className = className;
        this.isInterface = isInterface;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassInfo classInfo = (ClassInfo)o;
        return this.isInterface == classInfo.isInterface && Objects.equals(this.className, classInfo.className) && Objects.equals(this.superName, classInfo.superName) && Objects.equals(this.implementedInterfaces, classInfo.implementedInterfaces) && Objects.equals(this.methods, classInfo.methods) && Objects.equals(this.methodNameAndDescToMethodInfo, classInfo.methodNameAndDescToMethodInfo) && Objects.equals(this.instantiatedTypes, classInfo.instantiatedTypes) && Objects.equals(this.reflectedClasses, classInfo.reflectedClasses) && Objects.equals(this.reflectedMethodNames, classInfo.reflectedMethodNames);
    }

    public int hashCode() {
        return Objects.hash(this.className, this.superName, this.isInterface, this.implementedInterfaces, this.methods, this.methodNameAndDescToMethodInfo, this.instantiatedTypes, this.reflectedClasses, this.reflectedMethodNames);
    }

    public Optional<String> getSuperName() {
        return this.superName;
    }

    public Set<String> getImplementedInterfaces() {
        return Collections.unmodifiableSet(this.implementedInterfaces);
    }

    public Set<String> getInstantiatedTypes() {
        return Collections.unmodifiableSet(this.instantiatedTypes);
    }

    public Set<MethodDefinition> getMethods() {
        return Collections.unmodifiableSet(this.methods);
    }

    public Set<Type> getReflectedClasses() {
        return Collections.unmodifiableSet(this.reflectedClasses);
    }

    public Set<String> getReflectedMethodNames() {
        return Collections.unmodifiableSet(this.reflectedMethodNames);
    }

    public MethodInfo getMethodFromNameAndDesc(String methodName, String desc) {
        return this.methodNameAndDescToMethodInfo.get(new MethodNameAndDesc(methodName, desc));
    }

    public String getClassName() {
        return this.className;
    }

    boolean isInterface() {
        return this.isInterface;
    }

    private class MethodNameAndDesc {
        private final String methodName;
        private final String desc;

        private MethodNameAndDesc(String methodName, String desc) {
            this.methodName = methodName;
            this.desc = desc;
        }

        public int hashCode() {
            return Objects.hash(this.methodName, this.desc);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodNameAndDesc that = (MethodNameAndDesc)o;
            return Objects.equals(this.methodName, that.methodName) && Objects.equals(this.desc, that.desc);
        }
    }
}

