/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.methods;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sourceclear.methods.MethodInfo;
import java.util.Objects;

public class CallSite {
    @JsonProperty
    private final MethodInfo caller;
    @JsonProperty
    private final MethodInfo callee;
    @JsonProperty
    private final String fileName;
    @JsonProperty
    private final int lineNumber;

    @JsonCreator
    public CallSite(@JsonProperty(value="caller") MethodInfo caller, @JsonProperty(value="callee") MethodInfo callee, @JsonProperty(value="file_name") String fileName, @JsonProperty(value="line_number") int lineNumber) {
        this.caller = caller;
        this.callee = callee;
        this.fileName = fileName;
        this.lineNumber = lineNumber;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("CallSite{");
        sb.append("caller=").append(this.caller);
        sb.append(", callee=").append(this.callee);
        sb.append(", fileName=").append(this.fileName);
        sb.append(", lineNumber=").append(this.lineNumber);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CallSite callSite = (CallSite)o;
        return this.lineNumber == callSite.lineNumber && Objects.equals(this.caller, callSite.caller) && Objects.equals(this.callee, callSite.callee) && Objects.equals(this.fileName, callSite.fileName);
    }

    public int hashCode() {
        return Objects.hash(this.caller, this.callee, this.fileName, this.lineNumber);
    }

    public MethodInfo getCaller() {
        return this.caller;
    }

    public MethodInfo getCallee() {
        return this.callee;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }
}

