/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.librarydiffs.delta;

import com.sourceclear.librarydiffs.HashedMethod;
import com.sourceclear.methods.MethodInfo;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class LibSignature {
    private final Map<MethodInfo, HashedMethod> indexed;

    public LibSignature(Set<HashedMethod> set) {
        this();
        this.addAll(set);
    }

    public LibSignature(Map<MethodInfo, HashedMethod> indexed) {
        this.indexed = indexed;
    }

    public LibSignature() {
        this.indexed = new HashMap<MethodInfo, HashedMethod>();
    }

    public Set<HashedMethod> hashedMethods() {
        return new HashSet<HashedMethod>(this.indexed.values());
    }

    public Set<MethodInfo> methods() {
        return this.indexed.keySet();
    }

    public boolean contains(MethodInfo m) {
        return this.indexed.containsKey(m);
    }

    public HashedMethod get(MethodInfo m) {
        return this.indexed.get(m);
    }

    public void overwrite(HashedMethod hm) {
        this.indexed.put(hm.getMethod(), hm);
    }

    public void overwriteAll(Collection<HashedMethod> hm) {
        hm.forEach(this::overwrite);
    }

    private void add(HashedMethod hm) {
        if (this.indexed.containsKey(hm.getMethod())) {
            LibSignature.die();
        }
        this.overwrite(hm);
    }

    public void addAll(Collection<HashedMethod> hm) {
        hm.forEach(this::add);
    }

    public void addAll(LibSignature sig) {
        this.addAll(sig.indexed.values());
    }

    private void combine(HashedMethod hm) {
        MethodInfo m = hm.getMethod();
        if (this.indexed.containsKey(m)) {
            this.indexed.put(m, this.indexed.get(m).combine(hm));
        } else {
            this.indexed.put(m, hm);
        }
    }

    public void combineAll(Collection<HashedMethod> hm) {
        hm.forEach(this::combine);
    }

    private static void die() {
        throw new IllegalStateException("indexing methods revealed duplicates");
    }
}

