/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.scan;

import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableSet;
import com.sourceclear.api.client.Client;
import com.sourceclear.api.data.ScanType;
import com.sourceclear.api.data.analytics.AgentRuntimeData;
import com.sourceclear.api.data.evidence.Evidence;
import com.sourceclear.api.data.git.GitCommit;
import com.sourceclear.api.data.git.MetaGit;
import com.sourceclear.api.data.match.ContainerId;
import com.sourceclear.api.data.match.MatchQuery;
import com.sourceclear.api.data.match.MatchResponse;
import com.sourceclear.api.data.match.ScanFinishUploadResponse;
import com.sourceclear.api.data.methods.InstanceVulnMethod;
import com.sourceclear.api.data.methods.InstanceVulnMethodUpload;
import com.sourceclear.engine.common.CollectionResult;
import com.sourceclear.engine.scan.SrcclrScanUnexpectedCondition;
import com.sourceclear.util.config.ScanConfig;
import com.veracode.security.logging.SecureLogger;
import io.vavr.CheckedRunnable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PlatformScan {
    private static final SecureLogger LOGGER = SecureLogger.getLogger(PlatformScan.class);

    public static MatchResponse match(Client client, ScanConfig config, @Nonnull CollectionResult collectionResult, @Nonnull MetaGit metaGit, boolean shouldUpload, @Nullable AgentRuntimeData agentRuntimeData, @Nullable ImmutableSet<GitCommit> commitLog) throws SrcclrScanUnexpectedCondition {
        ImmutableSet<Evidence> evidence = collectionResult.getEvidence();
        try {
            Stopwatch executionStopwatch = Stopwatch.createStarted();
            MatchResponse matchResponse = client.match(PlatformScan.buildRepoMatchQuery(config, evidence, metaGit, collectionResult.isMethodsSupported(), shouldUpload, collectionResult.getLineCount(), agentRuntimeData != null ? agentRuntimeData : collectionResult.getAgentRuntimeData(), commitLog));
            LOGGER.debug("Matched in {} seconds.", (Object)executionStopwatch.elapsed(TimeUnit.SECONDS));
            return matchResponse;
        }
        catch (IOException ex) {
            LOGGER.debug("IOException when sending match request:", ex);
            throw new SrcclrScanUnexpectedCondition(ex.getMessage(), ex);
        }
    }

    public static MatchResponse match(Client client, ScanConfig config, @Nonnull CollectionResult collectionResult, @Nonnull ContainerId containerId, boolean shouldUpload, @Nullable AgentRuntimeData agentRuntimeData) throws SrcclrScanUnexpectedCondition {
        ImmutableSet<Evidence> evidence = collectionResult.getEvidence();
        try {
            Stopwatch executionStopwatch = Stopwatch.createStarted();
            MatchResponse matchResponse = client.match(PlatformScan.buildContainerMatchQuery(config, evidence, containerId, shouldUpload, agentRuntimeData != null ? agentRuntimeData : collectionResult.getAgentRuntimeData()));
            LOGGER.debug("Matched in {} seconds.", (Object)executionStopwatch.elapsed(TimeUnit.SECONDS));
            return matchResponse;
        }
        catch (IOException ex) {
            LOGGER.debug("IOException when sending match request:", ex);
            throw new SrcclrScanUnexpectedCondition(ex.getMessage(), ex);
        }
    }

    public static void completeForFailedRepoScans(Client client, ScanConfig config, @Nonnull MetaGit metaGit, boolean shouldUpload, @Nonnull AgentRuntimeData agentRuntimeData) throws SrcclrScanUnexpectedCondition {
        PlatformScan.sendFailedMatchRequest(() -> client.match(PlatformScan.buildRepoMatchQuery(config, null, metaGit, false, shouldUpload, null, agentRuntimeData, null)));
    }

    public static void completeForFailedContainerScans(Client client, ScanConfig config, @Nonnull ContainerId containerId, boolean shouldUpload, @Nonnull AgentRuntimeData agentRuntimeData) throws SrcclrScanUnexpectedCondition {
        PlatformScan.sendFailedMatchRequest(() -> client.match(PlatformScan.buildContainerMatchQuery(config, null, containerId, shouldUpload, agentRuntimeData)));
    }

    public static Optional<ScanFinishUploadResponse> finishScan(Client client, boolean withPolicy, String scanId, List<InstanceVulnMethod> vulnMethods, @Nonnull AgentRuntimeData agentRuntimeData) {
        Optional<ScanFinishUploadResponse> response;
        block5: {
            InstanceVulnMethodUpload.Builder builder = new InstanceVulnMethodUpload.Builder().setAgentRuntimeData(agentRuntimeData);
            if (vulnMethods != null) {
                builder.addAllVulnMethods(vulnMethods);
            }
            InstanceVulnMethodUpload vmUpload = builder.build();
            response = Optional.empty();
            try {
                if (withPolicy) {
                    ScanFinishUploadResponse scanFinishUploadResponse = client.callScanFinishAndUploadVulnMethods(scanId, vmUpload);
                    response = Optional.ofNullable(scanFinishUploadResponse);
                } else {
                    client.uploadVulnerableMethods(scanId, vmUpload);
                }
            }
            catch (Exception e) {
                LOGGER.error("Encountered error during vulnerable method upload.", e);
                if (withPolicy) break block5;
                LOGGER.error("Vulnerable methods upload failed for non-policy scan.");
            }
        }
        return response;
    }

    private static MatchQuery buildRepoMatchQuery(ScanConfig config, @Nullable ImmutableSet<Evidence> evidence, @Nonnull MetaGit metaGit, boolean methodsSupported, boolean shouldUpload, @Nullable Long loc, @Nullable AgentRuntimeData agentRuntimeData, ImmutableSet<GitCommit> commitLog) {
        MatchQuery.Builder builder = PlatformScan.buildBaseMatchQuery(config, evidence, shouldUpload, agentRuntimeData).withScanType(ScanType.REPO).withMetaGit(metaGit);
        if (evidence != null) {
            builder.requestVulnMethods(methodsSupported).requestPublicMethods(methodsSupported).withLinesOfCode(loc);
        }
        builder.withCommitLog((Collection<GitCommit>)commitLog);
        return builder.build();
    }

    private static MatchQuery buildContainerMatchQuery(ScanConfig config, @Nullable ImmutableSet<Evidence> evidence, @Nonnull ContainerId containerId, boolean shouldUpload, @Nullable AgentRuntimeData agentRuntimeData) {
        return PlatformScan.buildBaseMatchQuery(config, evidence, shouldUpload, agentRuntimeData).withScanType(ScanType.CONTAINER).withContainer(containerId.name(), containerId.tag(), containerId.hash()).build();
    }

    private static MatchQuery.Builder buildBaseMatchQuery(ScanConfig config, @Nullable ImmutableSet<Evidence> evidence, boolean shouldUpload, @Nullable AgentRuntimeData agentRuntimeData) {
        MatchQuery.Builder builder = new MatchQuery.Builder().withScanId(config.getScanID()).withProjectName(config.getProjectName()).persist(shouldUpload).withAgentRuntimeData(agentRuntimeData).withWorkspaceSlug(config.getWorkspaceSlug().orElse(null)).withLinkedRepoId(config.getLinkedRepoId());
        if (evidence != null) {
            builder.withEvidence(new ArrayList<Evidence>((Collection<Evidence>)evidence));
        } else {
            LOGGER.debug("Evidence set is empty after collection.");
            builder.withEvidence(null);
        }
        return builder;
    }

    private static void sendFailedMatchRequest(CheckedRunnable f) throws SrcclrScanUnexpectedCondition {
        try {
            Stopwatch executionStopwatch = Stopwatch.createStarted();
            f.run();
            LOGGER.debug("Matched in {} seconds.", (Object)executionStopwatch.elapsed(TimeUnit.SECONDS));
        }
        catch (Throwable ex) {
            LOGGER.debug("IOException when sending match request:", ex);
            throw new SrcclrScanUnexpectedCondition(ex.getMessage(), ex);
        }
    }
}

