/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.methods;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.sourceclear.engine.common.StoredFileVisitor;
import com.sourceclear.engine.common.logging.LogStream;
import com.sourceclear.engine.common.logging.Stage;
import com.sourceclear.engine.methods.MethodScanBatcher;
import com.sourceclear.methods.EntryPointResolver;
import com.sourceclear.methods.MethodInfo;
import com.sourceclear.methods.MethodScanner;
import com.sourceclear.methods.MethodScannerFactory;
import com.sourceclear.methods.PermissiveEntryPointResolver;
import com.sourceclear.methods.VulnMethodsInput;
import com.veracode.security.logging.SecureLogger;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

final class SimpleFileMethodScanBatcher
extends MethodScanBatcher {
    private final EntryPointResolver ENTRY_POINT_RESOLVER = new PermissiveEntryPointResolver();
    private final StoredFileVisitor visitor;
    private static final SecureLogger LOGGER = SecureLogger.getLogger(SimpleFileMethodScanBatcher.class);
    private final MethodScannerFactory methodScannerFactory;
    private final LogStream logStream;

    private Set<Path> getFiles(Path scanRoot, LogStream logStream) throws IOException {
        Set<String> fileTypes = this.visitor.getFileTypesLookedFor();
        LOGGER.debug("Looking for files of type: {}", (Object)fileTypes);
        Files.walkFileTree(scanRoot, this.visitor);
        ImmutableSet<Path> files2 = this.visitor.getFiles();
        String types = Joiner.on((String)", ").join(fileTypes);
        LOGGER.debug("Found files: {}", (Object)files2);
        logStream.log("com.srcclr.evidence.files.collecting", Stage.VULNERABLE_METHODS_SCAN, "Found " + files2.size() + " " + types + " files for vulnerable method analysis.");
        return files2;
    }

    public SimpleFileMethodScanBatcher(MethodScannerFactory methodScannerFactory, LogStream logStream, StoredFileVisitor visitor2) {
        this.methodScannerFactory = methodScannerFactory;
        this.logStream = logStream;
        this.visitor = visitor2;
    }

    @Override
    public final MethodScanBatcher.Result batch(Path scanRoot, Collection<MethodInfo> methods, VulnMethodsInput input) throws IOException {
        Set<Path> files2 = this.getFiles(scanRoot, this.logStream);
        MethodScanner scanner = this.methodScannerFactory.withInput(input).forFiles(files2, methods, this.ENTRY_POINT_RESOLVER);
        MethodScanner.VMReport result = scanner.scan();
        return new MethodScanBatcher.Result(result, Collections.singleton(scanner.getCallGraph()));
    }
}

