/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.methods;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.sourceclear.api.data.methods.FrameworkMethod;
import com.sourceclear.engine.methods.InstanceFrameworkMethod;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.stream.BaseStream;

abstract class InstanceFrameworkMethod_Builder {
    private String libraryInstanceRef;
    private List<FrameworkMethod> frameworkMethods = ImmutableList.of();
    private final EnumSet<Property> _unsetProperties = EnumSet.allOf(Property.class);

    InstanceFrameworkMethod_Builder() {
    }

    public static InstanceFrameworkMethod.Builder from(InstanceFrameworkMethod value) {
        if (value instanceof Rebuildable) {
            return ((Rebuildable)value).toBuilder();
        }
        return new InstanceFrameworkMethod.Builder().mergeFrom(value);
    }

    @JsonProperty(value="libraryInstanceRef")
    public InstanceFrameworkMethod.Builder libraryInstanceRef(String libraryInstanceRef) {
        this.libraryInstanceRef = Objects.requireNonNull(libraryInstanceRef);
        this._unsetProperties.remove((Object)Property.LIBRARY_INSTANCE_REF);
        return (InstanceFrameworkMethod.Builder)this;
    }

    public InstanceFrameworkMethod.Builder mapLibraryInstanceRef(UnaryOperator<String> mapper) {
        Objects.requireNonNull(mapper);
        return this.libraryInstanceRef((String)mapper.apply(this.libraryInstanceRef()));
    }

    public String libraryInstanceRef() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.LIBRARY_INSTANCE_REF) ? 1 : 0) != 0, (Object)"libraryInstanceRef not set");
        return this.libraryInstanceRef;
    }

    public InstanceFrameworkMethod.Builder addFrameworkMethods(FrameworkMethod element) {
        if (this.frameworkMethods instanceof ImmutableList) {
            this.frameworkMethods = new ArrayList<FrameworkMethod>(this.frameworkMethods);
        }
        this.frameworkMethods.add(Objects.requireNonNull(element));
        return (InstanceFrameworkMethod.Builder)this;
    }

    public InstanceFrameworkMethod.Builder addFrameworkMethods(FrameworkMethod ... elements) {
        return this.addAllFrameworkMethods(Arrays.asList(elements));
    }

    public InstanceFrameworkMethod.Builder addAllFrameworkMethods(Spliterator<? extends FrameworkMethod> elements) {
        long elementsSize;
        if ((elements.characteristics() & 0x40) != 0 && (elementsSize = elements.estimateSize()) > 0L && elementsSize <= Integer.MAX_VALUE) {
            if (this.frameworkMethods instanceof ImmutableList) {
                this.frameworkMethods = new ArrayList<FrameworkMethod>(this.frameworkMethods);
            }
            ((ArrayList)this.frameworkMethods).ensureCapacity(this.frameworkMethods.size() + (int)elementsSize);
        }
        elements.forEachRemaining(this::addFrameworkMethods);
        return (InstanceFrameworkMethod.Builder)this;
    }

    public InstanceFrameworkMethod.Builder addAllFrameworkMethods(BaseStream<? extends FrameworkMethod, ?> elements) {
        return this.addAllFrameworkMethods(elements.spliterator());
    }

    @JsonProperty(value="frameworkMethods")
    public InstanceFrameworkMethod.Builder addAllFrameworkMethods(Iterable<? extends FrameworkMethod> elements) {
        return this.addAllFrameworkMethods(elements.spliterator());
    }

    public InstanceFrameworkMethod.Builder mutateFrameworkMethods(Consumer<? super List<FrameworkMethod>> mutator) {
        if (this.frameworkMethods instanceof ImmutableList) {
            this.frameworkMethods = new ArrayList<FrameworkMethod>(this.frameworkMethods);
        }
        mutator.accept(this.frameworkMethods);
        return (InstanceFrameworkMethod.Builder)this;
    }

    public InstanceFrameworkMethod.Builder clearFrameworkMethods() {
        if (this.frameworkMethods instanceof ImmutableList) {
            this.frameworkMethods = ImmutableList.of();
        } else {
            this.frameworkMethods.clear();
        }
        return (InstanceFrameworkMethod.Builder)this;
    }

    public List<FrameworkMethod> frameworkMethods() {
        if (this.frameworkMethods instanceof ImmutableList) {
            this.frameworkMethods = new ArrayList<FrameworkMethod>(this.frameworkMethods);
        }
        return Collections.unmodifiableList(this.frameworkMethods);
    }

    public InstanceFrameworkMethod.Builder mergeFrom(InstanceFrameworkMethod value) {
        InstanceFrameworkMethod.Builder defaults = new InstanceFrameworkMethod.Builder();
        if (defaults._unsetProperties.contains((Object)Property.LIBRARY_INSTANCE_REF) || !Objects.equals(value.libraryInstanceRef(), ((InstanceFrameworkMethod_Builder)defaults).libraryInstanceRef())) {
            this.libraryInstanceRef(value.libraryInstanceRef());
        }
        if (value instanceof Value && this.frameworkMethods == ImmutableList.of()) {
            this.frameworkMethods = ImmutableList.copyOf(value.frameworkMethods());
        } else {
            this.addAllFrameworkMethods(value.frameworkMethods());
        }
        return (InstanceFrameworkMethod.Builder)this;
    }

    public InstanceFrameworkMethod.Builder mergeFrom(InstanceFrameworkMethod.Builder template) {
        InstanceFrameworkMethod.Builder base = template;
        InstanceFrameworkMethod.Builder defaults = new InstanceFrameworkMethod.Builder();
        if (!(base._unsetProperties.contains((Object)Property.LIBRARY_INSTANCE_REF) || !defaults._unsetProperties.contains((Object)Property.LIBRARY_INSTANCE_REF) && Objects.equals(template.libraryInstanceRef(), ((InstanceFrameworkMethod_Builder)defaults).libraryInstanceRef()))) {
            this.libraryInstanceRef(template.libraryInstanceRef());
        }
        this.addAllFrameworkMethods(base.frameworkMethods);
        return (InstanceFrameworkMethod.Builder)this;
    }

    public InstanceFrameworkMethod.Builder clear() {
        InstanceFrameworkMethod.Builder defaults = new InstanceFrameworkMethod.Builder();
        this.libraryInstanceRef = defaults.libraryInstanceRef;
        this.clearFrameworkMethods();
        this._unsetProperties.clear();
        this._unsetProperties.addAll(defaults._unsetProperties);
        return (InstanceFrameworkMethod.Builder)this;
    }

    public InstanceFrameworkMethod build() {
        Preconditions.checkState((boolean)this._unsetProperties.isEmpty(), (String)"Not set: %s", this._unsetProperties);
        return new Value(this);
    }

    @VisibleForTesting
    public InstanceFrameworkMethod buildPartial() {
        return new Partial(this);
    }

    private static final class Partial
    extends Rebuildable {
        private final String libraryInstanceRef;
        private final ImmutableList<FrameworkMethod> frameworkMethods;
        private final EnumSet<Property> _unsetProperties;

        Partial(InstanceFrameworkMethod_Builder builder) {
            this.libraryInstanceRef = builder.libraryInstanceRef;
            this.frameworkMethods = ImmutableList.copyOf((Collection)builder.frameworkMethods);
            this._unsetProperties = builder._unsetProperties.clone();
        }

        @Override
        @JsonProperty(value="libraryInstanceRef")
        public String libraryInstanceRef() {
            if (this._unsetProperties.contains((Object)Property.LIBRARY_INSTANCE_REF)) {
                throw new UnsupportedOperationException("libraryInstanceRef not set");
            }
            return this.libraryInstanceRef;
        }

        @Override
        @JsonProperty(value="frameworkMethods")
        public Collection<FrameworkMethod> frameworkMethods() {
            return this.frameworkMethods;
        }

        @Override
        public InstanceFrameworkMethod.Builder toBuilder() {
            PartialBuilder builder = new PartialBuilder();
            ((InstanceFrameworkMethod_Builder)builder).libraryInstanceRef = this.libraryInstanceRef;
            ((InstanceFrameworkMethod_Builder)builder).frameworkMethods = this.frameworkMethods;
            ((InstanceFrameworkMethod_Builder)builder)._unsetProperties.clear();
            ((InstanceFrameworkMethod_Builder)builder)._unsetProperties.addAll(this._unsetProperties);
            return builder;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Partial)) {
                return false;
            }
            Partial other = (Partial)obj;
            return Objects.equals(this.libraryInstanceRef, other.libraryInstanceRef) && Objects.equals(this.frameworkMethods, other.frameworkMethods) && Objects.equals(this._unsetProperties, other._unsetProperties);
        }

        public int hashCode() {
            return Objects.hash(this.libraryInstanceRef, this.frameworkMethods, this._unsetProperties);
        }

        public String toString() {
            StringBuilder result = new StringBuilder("partial InstanceFrameworkMethod{");
            if (!this._unsetProperties.contains((Object)Property.LIBRARY_INSTANCE_REF)) {
                result.append("libraryInstanceRef=").append(this.libraryInstanceRef).append(", ");
            }
            return result.append("frameworkMethods=").append(this.frameworkMethods).append("}").toString();
        }

        private static class PartialBuilder
        extends InstanceFrameworkMethod.Builder {
            private PartialBuilder() {
            }

            @Override
            public InstanceFrameworkMethod build() {
                return this.buildPartial();
            }
        }
    }

    private static final class Value
    extends Rebuildable {
        private final String libraryInstanceRef;
        private final ImmutableList<FrameworkMethod> frameworkMethods;

        private Value(InstanceFrameworkMethod_Builder builder) {
            this.libraryInstanceRef = builder.libraryInstanceRef;
            this.frameworkMethods = ImmutableList.copyOf((Collection)builder.frameworkMethods);
        }

        @Override
        @JsonProperty(value="libraryInstanceRef")
        public String libraryInstanceRef() {
            return this.libraryInstanceRef;
        }

        @Override
        @JsonProperty(value="frameworkMethods")
        public Collection<FrameworkMethod> frameworkMethods() {
            return this.frameworkMethods;
        }

        @Override
        public InstanceFrameworkMethod.Builder toBuilder() {
            InstanceFrameworkMethod.Builder builder = new InstanceFrameworkMethod.Builder();
            ((InstanceFrameworkMethod_Builder)builder).libraryInstanceRef = this.libraryInstanceRef;
            ((InstanceFrameworkMethod_Builder)builder).frameworkMethods = this.frameworkMethods;
            ((InstanceFrameworkMethod_Builder)builder)._unsetProperties.clear();
            return builder;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Value)) {
                return false;
            }
            Value other = (Value)obj;
            return Objects.equals(this.libraryInstanceRef, other.libraryInstanceRef) && Objects.equals(this.frameworkMethods, other.frameworkMethods);
        }

        public int hashCode() {
            return Objects.hash(this.libraryInstanceRef, this.frameworkMethods);
        }

        public String toString() {
            return "InstanceFrameworkMethod{libraryInstanceRef=" + this.libraryInstanceRef + ", frameworkMethods=" + this.frameworkMethods + "}";
        }
    }

    private static abstract class Rebuildable
    implements InstanceFrameworkMethod {
        private Rebuildable() {
        }

        public abstract InstanceFrameworkMethod.Builder toBuilder();
    }

    private static enum Property {
        LIBRARY_INSTANCE_REF("libraryInstanceRef");

        private final String name;

        private Property(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

