/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.methods;

import com.google.common.collect.ImmutableSet;
import com.sourceclear.analysis.latte.frameworks.Frameworks;
import com.sourceclear.api.data.methods.CallChainModel;
import com.sourceclear.api.data.methods.CallSiteModel;
import com.sourceclear.api.data.methods.MethodCallData;
import com.sourceclear.api.data.methods.MethodModel;
import com.sourceclear.engine.common.logging.LogStream;
import com.sourceclear.engine.methods.InstanceFrameworkMethod;
import com.sourceclear.engine.methods.MethodScanBatcher;
import com.sourceclear.engine.methods.MethodUtils;
import com.sourceclear.engine.methods.MethodsEngine;
import com.sourceclear.methods.CallChain;
import com.sourceclear.methods.CallSite;
import com.sourceclear.methods.MethodInfo;
import com.sourceclear.methods.MethodInfoImpl;
import com.sourceclear.methods.VulnMethodsInput;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

abstract class BaseMethodsEngine
implements MethodsEngine {
    BaseMethodsEngine() {
    }

    @Override
    public MethodsEngine withDynamicEdges(Set<CallSite> edges) {
        return this;
    }

    @Override
    public MethodsEngine withPublicMethodStubs(Collection<MethodInfo> publicMethodStubs) {
        return this;
    }

    @Override
    public Collection<MethodInfo> getPublicMethodStubs() {
        return Collections.emptySet();
    }

    @Override
    public MethodsEngine withFrameworkMethodStubs(Collection<InstanceFrameworkMethod> frameworkMethods) {
        return this;
    }

    @Override
    public Collection<Frameworks.Module> getFrameworkMethodStubs() {
        return Collections.emptySet();
    }

    @Override
    public Set<CallSite> getDynamicEdges() {
        return Collections.emptySet();
    }

    @Override
    public MethodInfo toMethodInfo(MethodModel methodModel, boolean ignoreNoModuleName) {
        return new MethodInfoImpl(methodModel.getModuleName(), methodModel.getClassName(), methodModel.getMethodName(), methodModel.getDescriptor());
    }

    abstract MethodScanBatcher setupBatcher(Path var1, LogStream var2) throws IOException;

    MethodsEngine.Result innerScanMethods(Path scanRoot, Collection<MethodCallData> inputMethodData, LogStream logStream) throws IOException {
        HashSet<MethodInfo> vulnerableMethods = new HashSet<MethodInfo>();
        HashSet<MethodInfo> scanMethods = new HashSet<MethodInfo>();
        HashSet<MethodInfo> malformedVulnerableMethods = new HashSet<MethodInfo>();
        for (MethodCallData methodCallData : inputMethodData) {
            this.categorizeMethods(methodCallData, vulnerableMethods, scanMethods, malformedVulnerableMethods);
        }
        this.checkMalformed(vulnerableMethods, malformedVulnerableMethods);
        scanMethods.addAll(vulnerableMethods);
        VulnMethodsInput input = new VulnMethodsInput.Builder().addAllStaticCallChains(this.getStaticCallChains(inputMethodData)).addAllPublicMethods(this.getPublicMethodStubs()).addAllFrameworkMethods(this.getFrameworkMethodStubs()).addAllDynamicEdges(this.getDynamicEdges()).build();
        MethodScanBatcher batcher = this.setupBatcher(scanRoot, logStream);
        MethodScanBatcher.Result result = batcher.batch(scanRoot, vulnerableMethods, input);
        HashMap<CallChainModel, CallSite> spanning = new HashMap<CallChainModel, CallSite>();
        LinkedHashMap<MethodModel, MethodCallData> resultCallData = new LinkedHashMap<MethodModel, MethodCallData>();
        for (Collection<CallChain> callChains : result.scan.callChains.values()) {
            BaseMethodsEngine.adaptResults(scanMethods, callChains, resultCallData, result.scan.spanningEdges, spanning);
        }
        return new MethodsEngine.Result((Collection<MethodCallData>)ImmutableSet.copyOf(resultCallData.values()), result.graph, spanning);
    }

    private static void adaptResults(Set<MethodInfo> scanMethods, Collection<CallChain> callChains, Map<MethodModel, MethodCallData> resultCallData, Map<CallChain, CallSite> spanning, Map<CallChainModel, CallSite> spanningModel) {
        for (CallChain callChain : callChains) {
            CallChainModel callChainModel = new CallChainModel();
            spanningModel.put(callChainModel, spanning.get(callChain));
            for (CallSite call : callChain) {
                MethodInfo caller = call.getCaller();
                MethodInfo callee = call.getCallee();
                boolean internal = !scanMethods.contains(caller);
                MethodModel callerModel = MethodUtils.getMethodModel(caller);
                MethodModel calleeModel = MethodUtils.getMethodModel(callee);
                callChainModel.addCallSite(new CallSiteModel(callerModel, calleeModel, call.getFileName(), call.getLineNumber(), internal));
            }
            MethodModel targetMethod = callChainModel.getTargetMethod();
            MethodCallData methodCallData = resultCallData.get(targetMethod);
            if (methodCallData == null) {
                methodCallData = new MethodCallData(targetMethod);
                resultCallData.put(targetMethod, methodCallData);
            }
            methodCallData.addCallChain(callChainModel);
        }
    }

    @NotNull
    private List<List<CallSite>> getStaticCallChains(Collection<MethodCallData> inputMethodData) {
        return inputMethodData.stream().flatMap(md -> md.getCallChains().stream().map(cc -> cc.getCallSites().stream().map(c -> new CallSite(this.toMethodInfo(c.getCaller(), false), this.toMethodInfo(c.getCallee(), false), c.getFileName(), c.getLineNumber())).collect(Collectors.toList()))).collect(Collectors.toList());
    }

    protected void categorizeMethods(MethodCallData methodCallData, Set<MethodInfo> vulnerableMethods, Set<MethodInfo> scanMethods, Set<MethodInfo> malformedMethods) {
        vulnerableMethods.add(this.toMethodInfo(methodCallData.getMethod(), false));
        scanMethods.addAll(this.getScanMethods(methodCallData));
    }

    protected Set<MethodInfo> getScanMethods(MethodCallData methodCallData) {
        HashSet<MethodInfo> result = new HashSet<MethodInfo>();
        for (CallChainModel callChainModel : methodCallData) {
            for (CallSiteModel callSite : callChainModel) {
                MethodModel caller = callSite.getCaller();
                MethodInfo methodInfo = this.toMethodInfo(caller, false);
                result.add(methodInfo);
            }
        }
        return result;
    }

    protected void checkMalformed(Set<MethodInfo> vulnerableMethods, Set<MethodInfo> malformedMethods) {
    }
}

