/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.common.linecount;

import com.google.common.collect.ImmutableSet;
import com.sourceclear.engine.common.FileTypeVisitor;
import com.sourceclear.engine.common.linecount.Counter;
import com.veracode.security.logging.SecureLogger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;

public class SourceFileCounter
implements Counter {
    private static final Set<String> EXTENSIONS = new HashSet<String>(Arrays.asList(".py", ".java", ".js", ".groovy", ".m", ".mm", ".h", ".c", ".swift", ".py", ".rb", ".go", ".php"));
    private static final Set<String> IGNORED_DIRECTORIES = new HashSet<String>(Arrays.asList("target", "test", "examples", "docs", "Tests", "templates", "spec", "target", "node_modules", "dist", "packages", "vendor", "Pods"));
    private static final SecureLogger LOGGER = SecureLogger.getLogger(SourceFileCounter.class);
    private ImmutableSet<Path> filesFound;

    @Override
    public boolean shouldCount(File projectRoot) throws IOException {
        FileTypeVisitor fileTypeVisitor = new FileTypeVisitor(EXTENSIONS, IGNORED_DIRECTORIES);
        Files.walkFileTree(projectRoot.toPath(), fileTypeVisitor);
        this.filesFound = fileTypeVisitor.getFiles();
        return !this.filesFound.isEmpty();
    }

    @Override
    @Nonnull
    public String getName() {
        return "SourceLineCounter";
    }

    @Override
    public long count(File projectRoot) throws IOException {
        long count = 0L;
        byte[] buf = new byte[32768];
        for (Path path : this.filesFound) {
            InputStream stream = Files.newInputStream(path, StandardOpenOption.READ);
            try {
                int br;
                int lastChar = 0;
                boolean empty = true;
                while (-1 != (br = stream.read(buf))) {
                    if (br != 0) {
                        lastChar = buf[br - 1];
                    }
                    for (int i = 0; i < br; ++i) {
                        if (10 != buf[i]) continue;
                        ++count;
                    }
                    empty = false;
                }
                if (empty || 10 == lastChar) continue;
                ++count;
            }
            finally {
                if (stream == null) continue;
                stream.close();
            }
        }
        return count;
    }
}

