/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class EnvironmentVariableUtils {
    public static Collection<String> splitOnUnquotedWhitespace(String command) {
        if (command == null) {
            return Collections.emptyList();
        }
        String regexString = "\"(?<double>[^\"].*)(?<!\\\\)\"|'(?<single>[^'].*)(?<!\\\\)'|(?<plain>\\S+)";
        Pattern regex = Pattern.compile("\"(?<double>[^\"].*)(?<!\\\\)\"|'(?<single>[^'].*)(?<!\\\\)'|(?<plain>\\S+)");
        Matcher matcher = regex.matcher(command);
        ArrayList<String> result = new ArrayList<String>();
        while (matcher.find()) {
            String doubleQuoted = matcher.group("double");
            String singleQuoted = matcher.group("single");
            String plain = matcher.group("plain");
            if (doubleQuoted != null) {
                result.add(doubleQuoted);
                continue;
            }
            if (singleQuoted != null) {
                result.add(singleQuoted);
                continue;
            }
            result.add(plain);
        }
        return result;
    }

    public static Set<String> splitByComma(String str) {
        return Arrays.stream(str.split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toSet());
    }

    public static Set<String> splitByCommaAndUpperCase(String str) {
        return EnvironmentVariableUtils.splitByComma(str).stream().map(String::toUpperCase).collect(Collectors.toSet());
    }
}

