/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.common;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.sourceclear.api.data.evidence.Coordinates;
import java.util.Collection;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@Immutable
public class Component {
    private final Coordinates coords;
    private final ImmutableSet<Component> directs;
    private final String filename;
    private final Integer lineNumber;

    private Component(Builder builder) {
        this.coords = builder.coords;
        this.directs = ImmutableSet.copyOf((Collection)builder.directs);
        this.lineNumber = builder.lineNumber;
        this.filename = builder.filename;
    }

    public Coordinates getCoordinates() {
        return this.coords;
    }

    public ImmutableSet<Component> getDirects() {
        return this.directs;
    }

    public Integer getLineNumber() {
        return this.lineNumber;
    }

    public String getFilename() {
        return this.filename;
    }

    public static class Builder {
        private Set<Component> directs = Sets.newHashSet();
        private final Coordinates coords;
        private Integer lineNumber;
        private String filename;

        public Builder(Coordinates coords) {
            this.coords = coords;
        }

        public Builder(Coordinates coords, Integer lineNumber) {
            this.coords = coords;
            this.lineNumber = lineNumber;
        }

        public Builder withDirect(Component component) {
            this.directs.add(component);
            return this;
        }

        public Builder withLineNumber(Integer lineNumber) {
            this.lineNumber = lineNumber;
            return this;
        }

        public Builder withFilename(String filename) {
            this.filename = filename;
            return this;
        }

        public Component build() {
            return new Component(this);
        }
    }
}

