/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.bytecode;

import com.sourceclear.bytecode.CompClassMethodVisitor;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public class CompClassVisitor
extends ClassVisitor {
    private String className;
    private final Set<String> fieldsSet;
    private final Set<String> methodsSet;
    private final Map<String, List<Integer>> methodsMap;
    private final Set<String> calledMethodsSet;
    private final Set<String> algorithmsSet;

    public CompClassVisitor(String className, Set<String> fieldsSet, Set<String> methodsSet, Map<String, List<Integer>> methodsMap, Set<String> calledMethodsSet, Set<String> algorithmsSet, int ver) {
        super(ver);
        this.className = className;
        this.fieldsSet = fieldsSet;
        this.methodsSet = methodsSet;
        this.methodsMap = methodsMap;
        this.calledMethodsSet = calledMethodsSet;
        this.algorithmsSet = algorithmsSet;
    }

    public String getClassName() {
        return this.className;
    }

    public Set<String> getFieldsSet() {
        return this.fieldsSet;
    }

    public Set<String> getMethodsSet() {
        return this.methodsSet;
    }

    public Map<String, List<Integer>> getMethodsMap() {
        return this.methodsMap;
    }

    public Set<String> getCalledMethodsSet() {
        return this.calledMethodsSet;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.className = name + ":" + superName;
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        this.fieldsSet.add(name + ":" + desc);
        return null;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        this.methodsSet.add(name + ":" + desc);
        return new CompClassMethodVisitor(name + ":" + desc, this.methodsMap, this.calledMethodsSet, this.algorithmsSet, this.api);
    }
}

