/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.api.data.evidence;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.sourceclear.api.data.evidence.InstanceCommitHashModel;
import com.sourceclear.api.data.evidence.LibraryCommitHashModel;
import com.sourceclear.api.data.evidence.LibraryModel;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.stream.BaseStream;

abstract class LibraryCommitHashModel_Builder {
    private LibraryModel library;
    private final InstanceCommitHashModelBuilderList instanceCommitHashes = new InstanceCommitHashModelBuilderList();
    private final EnumSet<Property> _unsetProperties = EnumSet.allOf(Property.class);

    LibraryCommitHashModel_Builder() {
    }

    public static LibraryCommitHashModel.Builder from(LibraryCommitHashModel value) {
        if (value instanceof Rebuildable) {
            return ((Rebuildable)value).toBuilder();
        }
        return new LibraryCommitHashModel.Builder().mergeFrom(value);
    }

    @JsonProperty(value="library")
    public LibraryCommitHashModel.Builder setLibrary(LibraryModel library) {
        this.library = Objects.requireNonNull(library);
        this._unsetProperties.remove((Object)Property.LIBRARY);
        return (LibraryCommitHashModel.Builder)this;
    }

    public LibraryCommitHashModel.Builder mapLibrary(UnaryOperator<LibraryModel> mapper) {
        Objects.requireNonNull(mapper);
        return this.setLibrary((LibraryModel)mapper.apply(this.getLibrary()));
    }

    public LibraryModel getLibrary() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.LIBRARY) ? 1 : 0) != 0, (Object)"library not set");
        return this.library;
    }

    public LibraryCommitHashModel.Builder addInstanceCommitHashes(InstanceCommitHashModel element) {
        this.instanceCommitHashes.addValue(element);
        return (LibraryCommitHashModel.Builder)this;
    }

    public LibraryCommitHashModel.Builder addInstanceCommitHashes(InstanceCommitHashModel.Builder builder) {
        this.instanceCommitHashes.add(new InstanceCommitHashModel.Builder().mergeFrom(builder));
        return (LibraryCommitHashModel.Builder)this;
    }

    public LibraryCommitHashModel.Builder addInstanceCommitHashes(InstanceCommitHashModel ... elements) {
        return this.addAllInstanceCommitHashes(Arrays.asList(elements));
    }

    public LibraryCommitHashModel.Builder addInstanceCommitHashes(InstanceCommitHashModel.Builder ... elementBuilders) {
        return this.addAllBuildersOfInstanceCommitHashes(Arrays.asList(elementBuilders));
    }

    public LibraryCommitHashModel.Builder addAllInstanceCommitHashes(Spliterator<? extends InstanceCommitHashModel> elements) {
        long newSize;
        if ((elements.characteristics() & 0x40) != 0 && (newSize = elements.estimateSize() + (long)this.instanceCommitHashes.size()) <= Integer.MAX_VALUE) {
            this.instanceCommitHashes.ensureCapacity((int)newSize);
        }
        elements.forEachRemaining(this::addInstanceCommitHashes);
        return (LibraryCommitHashModel.Builder)this;
    }

    public LibraryCommitHashModel.Builder addAllBuildersOfInstanceCommitHashes(Spliterator<? extends InstanceCommitHashModel.Builder> elementBuilders) {
        long newSize;
        if ((elementBuilders.characteristics() & 0x40) != 0 && (newSize = elementBuilders.estimateSize() + (long)this.instanceCommitHashes.size()) <= Integer.MAX_VALUE) {
            this.instanceCommitHashes.ensureCapacity((int)newSize);
        }
        elementBuilders.forEachRemaining(this::addInstanceCommitHashes);
        return (LibraryCommitHashModel.Builder)this;
    }

    @JsonProperty(value="instanceCommitHashes")
    public LibraryCommitHashModel.Builder addAllInstanceCommitHashes(Iterable<? extends InstanceCommitHashModel> elements) {
        this.instanceCommitHashes.addAllValues(elements);
        return (LibraryCommitHashModel.Builder)this;
    }

    public LibraryCommitHashModel.Builder addAllBuildersOfInstanceCommitHashes(Iterable<? extends InstanceCommitHashModel.Builder> elementBuilders) {
        return this.addAllBuildersOfInstanceCommitHashes(elementBuilders.spliterator());
    }

    public LibraryCommitHashModel.Builder addAllInstanceCommitHashes(BaseStream<? extends InstanceCommitHashModel, ?> elements) {
        return this.addAllInstanceCommitHashes(elements.spliterator());
    }

    public LibraryCommitHashModel.Builder addAllBuildersOfInstanceCommitHashes(BaseStream<? extends InstanceCommitHashModel.Builder, ?> elementBuilders) {
        return this.addAllBuildersOfInstanceCommitHashes(elementBuilders.spliterator());
    }

    public LibraryCommitHashModel.Builder mutateInstanceCommitHashes(Consumer<? super List<InstanceCommitHashModel.Builder>> mutator) {
        mutator.accept(this.instanceCommitHashes);
        return (LibraryCommitHashModel.Builder)this;
    }

    public LibraryCommitHashModel.Builder clearInstanceCommitHashes() {
        this.instanceCommitHashes.clear();
        return (LibraryCommitHashModel.Builder)this;
    }

    public List<InstanceCommitHashModel.Builder> getBuildersOfInstanceCommitHashes() {
        return Collections.unmodifiableList(this.instanceCommitHashes);
    }

    public LibraryCommitHashModel.Builder mergeFrom(LibraryCommitHashModel value) {
        LibraryCommitHashModel.Builder defaults = new LibraryCommitHashModel.Builder();
        if (defaults._unsetProperties.contains((Object)Property.LIBRARY) || !Objects.equals(value.getLibrary(), ((LibraryCommitHashModel_Builder)defaults).getLibrary())) {
            this.setLibrary(value.getLibrary());
        }
        this.addAllInstanceCommitHashes(value.getInstanceCommitHashes());
        return (LibraryCommitHashModel.Builder)this;
    }

    public LibraryCommitHashModel.Builder mergeFrom(LibraryCommitHashModel.Builder template) {
        LibraryCommitHashModel.Builder base = template;
        LibraryCommitHashModel.Builder defaults = new LibraryCommitHashModel.Builder();
        if (!(base._unsetProperties.contains((Object)Property.LIBRARY) || !defaults._unsetProperties.contains((Object)Property.LIBRARY) && Objects.equals(template.getLibrary(), ((LibraryCommitHashModel_Builder)defaults).getLibrary()))) {
            this.setLibrary(template.getLibrary());
        }
        this.addAllBuildersOfInstanceCommitHashes(base.instanceCommitHashes);
        return (LibraryCommitHashModel.Builder)this;
    }

    public LibraryCommitHashModel.Builder clear() {
        LibraryCommitHashModel.Builder defaults = new LibraryCommitHashModel.Builder();
        this.library = defaults.library;
        this.clearInstanceCommitHashes();
        this._unsetProperties.clear();
        this._unsetProperties.addAll(defaults._unsetProperties);
        return (LibraryCommitHashModel.Builder)this;
    }

    public LibraryCommitHashModel build() {
        Preconditions.checkState((boolean)this._unsetProperties.isEmpty(), (String)"Not set: %s", this._unsetProperties);
        return new Value(this);
    }

    @VisibleForTesting
    public LibraryCommitHashModel buildPartial() {
        return new Partial(this);
    }

    private class InstanceCommitHashModelBuilderList
    extends AbstractList<InstanceCommitHashModel.Builder>
    implements RandomAccess {
        private List elements = ImmutableList.of();

        private InstanceCommitHashModelBuilderList() {
        }

        @Override
        public int size() {
            return this.elements.size();
        }

        @Override
        public InstanceCommitHashModel.Builder get(int index) {
            Object element = this.elements.get(index);
            if (element instanceof InstanceCommitHashModel) {
                if (this.elements instanceof ImmutableList) {
                    this.elements = new ArrayList(this.elements);
                }
                element = new InstanceCommitHashModel.Builder().mergeFrom((InstanceCommitHashModel)element);
                this.elements.set(index, element);
            }
            return (InstanceCommitHashModel.Builder)element;
        }

        @Override
        public InstanceCommitHashModel.Builder set(int index, InstanceCommitHashModel.Builder element) {
            InstanceCommitHashModel.Builder oldElement;
            if (this.elements instanceof ImmutableList) {
                this.elements = new ArrayList(this.elements);
            }
            if ((oldElement = this.elements.set(index, element)) instanceof InstanceCommitHashModel) {
                oldElement = new InstanceCommitHashModel.Builder().mergeFrom((InstanceCommitHashModel)((Object)oldElement));
            }
            return oldElement;
        }

        @Override
        public void add(int index, InstanceCommitHashModel.Builder element) {
            if (this.elements instanceof ImmutableList) {
                this.elements = new ArrayList(this.elements);
            }
            this.elements.add(index, element);
        }

        @Override
        public InstanceCommitHashModel.Builder remove(int index) {
            Object oldElement;
            if (this.elements instanceof ImmutableList) {
                this.elements = new ArrayList(this.elements);
            }
            if ((oldElement = this.elements.remove(index)) instanceof InstanceCommitHashModel) {
                oldElement = new InstanceCommitHashModel.Builder().mergeFrom((InstanceCommitHashModel)oldElement);
            }
            return (InstanceCommitHashModel.Builder)oldElement;
        }

        void ensureCapacity(int minCapacity) {
            if (this.elements instanceof ImmutableList) {
                this.elements = new ArrayList(this.elements);
            }
            ((ArrayList)this.elements).ensureCapacity(minCapacity);
        }

        void addValue(InstanceCommitHashModel element) {
            Objects.requireNonNull(element);
            if (this.elements instanceof ImmutableList) {
                this.elements = new ArrayList(this.elements);
            }
            this.elements.add(element);
        }

        void addAllValues(Iterable<? extends InstanceCommitHashModel> values) {
            if (this.elements.isEmpty() && values instanceof ImmutableList) {
                this.elements = (ImmutableList)values;
            } else {
                if (this.elements instanceof ImmutableList) {
                    this.elements = new ArrayList(this.elements);
                }
                if (values instanceof Collection) {
                    int newSize = this.elements.size() + ((Collection)values).size();
                    ((ArrayList)this.elements).ensureCapacity(newSize);
                }
                values.forEach(this::addValue);
            }
        }

        ImmutableList<InstanceCommitHashModel> build() {
            if (this.elements instanceof ImmutableList) {
                return (ImmutableList)this.elements;
            }
            ImmutableList.Builder values = ImmutableList.builder();
            for (Object element : this.elements) {
                values.add((Object)this.build(element));
            }
            return values.build();
        }

        private InstanceCommitHashModel build(Object element) {
            if (element instanceof InstanceCommitHashModel) {
                return (InstanceCommitHashModel)element;
            }
            return ((InstanceCommitHashModel.Builder)element).build();
        }

        ImmutableList<InstanceCommitHashModel> buildPartial() {
            if (this.elements instanceof ImmutableList) {
                return (ImmutableList)this.elements;
            }
            ImmutableList.Builder values = ImmutableList.builder();
            for (Object element : this.elements) {
                values.add((Object)this.buildPartial(element));
            }
            return values.build();
        }

        private InstanceCommitHashModel buildPartial(Object element) {
            if (element instanceof InstanceCommitHashModel) {
                return (InstanceCommitHashModel)element;
            }
            return ((InstanceCommitHashModel.Builder)element).buildPartial();
        }
    }

    private static final class Partial
    extends Rebuildable {
        private final LibraryModel library;
        private final ImmutableList<InstanceCommitHashModel> instanceCommitHashes;
        private final EnumSet<Property> _unsetProperties;

        Partial(LibraryCommitHashModel_Builder builder) {
            this.library = builder.library;
            this.instanceCommitHashes = builder.instanceCommitHashes.buildPartial();
            this._unsetProperties = builder._unsetProperties.clone();
        }

        @Override
        @JsonProperty(value="library")
        public LibraryModel getLibrary() {
            if (this._unsetProperties.contains((Object)Property.LIBRARY)) {
                throw new UnsupportedOperationException("library not set");
            }
            return this.library;
        }

        @Override
        @JsonProperty(value="instanceCommitHashes")
        public List<InstanceCommitHashModel> getInstanceCommitHashes() {
            return this.instanceCommitHashes;
        }

        @Override
        public LibraryCommitHashModel.Builder toBuilder() {
            PartialBuilder builder = new PartialBuilder();
            ((LibraryCommitHashModel_Builder)builder).library = this.library;
            ((LibraryCommitHashModel_Builder)builder).addAllInstanceCommitHashes((Iterable<? extends InstanceCommitHashModel>)this.instanceCommitHashes);
            ((LibraryCommitHashModel_Builder)builder)._unsetProperties.clear();
            ((LibraryCommitHashModel_Builder)builder)._unsetProperties.addAll(this._unsetProperties);
            return builder;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Partial)) {
                return false;
            }
            Partial other = (Partial)obj;
            return Objects.equals(this.library, other.library) && Objects.equals(this.instanceCommitHashes, other.instanceCommitHashes) && Objects.equals(this._unsetProperties, other._unsetProperties);
        }

        public int hashCode() {
            return Objects.hash(this.library, this.instanceCommitHashes, this._unsetProperties);
        }

        public String toString() {
            StringBuilder result = new StringBuilder("partial LibraryCommitHashModel{");
            if (!this._unsetProperties.contains((Object)Property.LIBRARY)) {
                result.append("library=").append(this.library).append(", ");
            }
            return result.append("instanceCommitHashes=").append(this.instanceCommitHashes).append("}").toString();
        }

        private static class PartialBuilder
        extends LibraryCommitHashModel.Builder {
            private PartialBuilder() {
            }

            @Override
            public LibraryCommitHashModel build() {
                return this.buildPartial();
            }
        }
    }

    private static final class Value
    extends Rebuildable {
        private final LibraryModel library;
        private final ImmutableList<InstanceCommitHashModel> instanceCommitHashes;

        private Value(LibraryCommitHashModel_Builder builder) {
            this.library = builder.library;
            this.instanceCommitHashes = builder.instanceCommitHashes.build();
        }

        @Override
        @JsonProperty(value="library")
        public LibraryModel getLibrary() {
            return this.library;
        }

        @Override
        @JsonProperty(value="instanceCommitHashes")
        public List<InstanceCommitHashModel> getInstanceCommitHashes() {
            return this.instanceCommitHashes;
        }

        @Override
        public LibraryCommitHashModel.Builder toBuilder() {
            LibraryCommitHashModel.Builder builder = new LibraryCommitHashModel.Builder();
            ((LibraryCommitHashModel_Builder)builder).library = this.library;
            ((LibraryCommitHashModel_Builder)builder).addAllInstanceCommitHashes((Iterable<? extends InstanceCommitHashModel>)this.instanceCommitHashes);
            ((LibraryCommitHashModel_Builder)builder)._unsetProperties.clear();
            return builder;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Value)) {
                return false;
            }
            Value other = (Value)obj;
            return Objects.equals(this.library, other.library) && Objects.equals(this.instanceCommitHashes, other.instanceCommitHashes);
        }

        public int hashCode() {
            return Objects.hash(this.library, this.instanceCommitHashes);
        }

        public String toString() {
            return "LibraryCommitHashModel{library=" + this.library + ", instanceCommitHashes=" + this.instanceCommitHashes + "}";
        }
    }

    private static abstract class Rebuildable
    implements LibraryCommitHashModel {
        private Rebuildable() {
        }

        public abstract LibraryCommitHashModel.Builder toBuilder();
    }

    private static enum Property {
        LIBRARY("library");

        private final String name;

        private Property(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

